/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3ServerConnectionHandler;
import io.netty.incubator.codec.quic.InsecureQuicTokenHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http3.netty4.NettyHttp3FrameCodec;
import org.apache.dubbo.remoting.http3.netty4.NettyHttp3ProtocolSelectorHandler;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty4.Helper;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class NettyHttp3Server
extends AbstractServer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyHttp3Server.class);
    private Map<String, Channel> channels;
    private Bootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private io.netty.channel.Channel channel;
    private final int serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.getUrl().getOrDefaultModuleModel());

    public NettyHttp3Server(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap((ChannelHandler)handler, (URL)url));
    }

    protected void doOpen() throws Throwable {
        this.bootstrap = new Bootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup((int)1, (String)"NettyServerBoss");
        final NettyServerHandler nettyServerHandler = new NettyServerHandler(this.getUrl(), (ChannelHandler)this);
        this.channels = nettyServerHandler.getChannels();
        FrameworkModel frameworkModel = ScopeModelUtil.getFrameworkModel((ScopeModel)this.getUrl().getScopeModel());
        final NettyHttp3ProtocolSelectorHandler selectorHandler = new NettyHttp3ProtocolSelectorHandler(this.getUrl(), frameworkModel);
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        QuicSslContext context = QuicSslContextBuilder.forServer((File)certificate.privateKey(), null, (File)certificate.certificate()).applicationProtocols(Http3.supportedApplicationProtocols()).build();
        final int idleTimeout = UrlUtils.getIdleTimeout((URL)this.getUrl());
        io.netty.channel.ChannelHandler codec = ((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)Helper.configCodec(Http3.newQuicServerCodecBuilder(), this.getUrl())).sslContext(context)).maxIdleTimeout((long)idleTimeout, TimeUnit.MILLISECONDS)).tokenHandler((QuicTokenHandler)InsecureQuicTokenHandler.INSTANCE).handler((io.netty.channel.ChannelHandler)new ChannelInitializer<QuicChannel>(){

            protected void initChannel(QuicChannel ch) {
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{nettyServerHandler}).addLast(new io.netty.channel.ChannelHandler[]{new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS)}).addLast(new io.netty.channel.ChannelHandler[]{new Http3ServerConnectionHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                    protected void initChannel(QuicStreamChannel ch) {
                        ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{NettyHttp3FrameCodec.INSTANCE}).addLast(new io.netty.channel.ChannelHandler[]{new HttpWriteQueueHandler()}).addLast(new io.netty.channel.ChannelHandler[]{selectorHandler});
                    }
                })});
            }
        }).build();
        try {
            ChannelFuture channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.bossGroup)).channel(NioDatagramChannel.class)).handler(codec)).bind((SocketAddress)this.getBindAddress());
            channelFuture.syncUninterruptibly();
            this.channel = channelFuture.channel();
        }
        catch (Throwable t) {
            this.closeBootstrap();
            throw t;
        }
    }

    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        logger.warn("6-3", "", "", e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        this.closeBootstrap();
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    private void closeBootstrap() {
        try {
            if (this.bootstrap != null) {
                long timeout = ConfigurationUtils.reCalShutdownTime((int)this.serverShutdownTimeoutMills);
                long quietPeriod = Math.min(2000L, timeout);
                Future bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    protected int getChannelsSize() {
        return this.channels.size();
    }

    public Collection<Channel> getChannels() {
        return new ArrayList<Channel>(this.channels.values());
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }

    public boolean canHandleIdle() {
        return true;
    }

    public boolean isBound() {
        return this.channel.isActive();
    }
}

