/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.mina;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.transport.mina.MinaChannel;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class MinaHandler
extends IoHandlerAdapter {
    private final URL url;
    private final ChannelHandler handler;

    public MinaHandler(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    public void sessionOpened(IoSession session) throws Exception {
        MinaChannel channel = MinaChannel.getOrAddChannel(session, this.url, this.handler);
        try {
            this.handler.connected((Channel)channel);
        }
        finally {
            MinaChannel.removeChannelIfDisconnected(session);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        MinaChannel channel = MinaChannel.getOrAddChannel(session, this.url, this.handler);
        try {
            this.handler.disconnected((Channel)channel);
        }
        finally {
            MinaChannel.removeChannelIfDisconnected(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) throws Exception {
        MinaChannel channel = MinaChannel.getOrAddChannel(session, this.url, this.handler);
        try {
            this.handler.received((Channel)channel, message);
        }
        finally {
            MinaChannel.removeChannelIfDisconnected(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(IoSession session, Object message) throws Exception {
        MinaChannel channel = MinaChannel.getOrAddChannel(session, this.url, this.handler);
        try {
            this.handler.sent((Channel)channel, message);
        }
        finally {
            MinaChannel.removeChannelIfDisconnected(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        MinaChannel channel = MinaChannel.getOrAddChannel(session, this.url, this.handler);
        try {
            this.handler.caught((Channel)channel, cause);
        }
        finally {
            MinaChannel.removeChannelIfDisconnected(session);
        }
    }
}

