/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.mina.MinaChannel;
import org.apache.dubbo.remoting.transport.mina.MinaCodecAdapter;
import org.apache.dubbo.remoting.transport.mina.MinaHandler;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class MinaServer
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(MinaServer.class);
    private SocketAcceptor acceptor;

    public MinaServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap((ChannelHandler)handler, (URL)ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler")));
    }

    protected void doOpen() throws Throwable {
        this.acceptor = new SocketAcceptor(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), (Executor)Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("MinaServerWorker", true)));
        SocketAcceptorConfig cfg = this.acceptor.getDefaultConfig();
        cfg.setThreadModel(ThreadModel.MANUAL);
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MinaCodecAdapter(this.getCodec(), this.getUrl(), (ChannelHandler)this)));
        this.acceptor.bind((SocketAddress)this.getBindAddress(), (IoHandler)new MinaHandler(this.getUrl(), (ChannelHandler)this));
    }

    protected void doClose() throws Throwable {
        try {
            if (this.acceptor != null) {
                this.acceptor.unbind((SocketAddress)this.getBindAddress());
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public Collection<Channel> getChannels() {
        Set sessions = this.acceptor.getManagedSessions((SocketAddress)this.getBindAddress());
        HashSet<Channel> channels = new HashSet<Channel>();
        for (IoSession session : sessions) {
            if (!session.isConnected()) continue;
            channels.add((Channel)MinaChannel.getOrAddChannel(session, this.getUrl(), (ChannelHandler)this));
        }
        return channels;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        Set sessions = this.acceptor.getManagedSessions((SocketAddress)this.getBindAddress());
        for (IoSession session : sessions) {
            if (!session.getRemoteAddress().equals(remoteAddress)) continue;
            return MinaChannel.getOrAddChannel(session, this.getUrl(), (ChannelHandler)this);
        }
        return null;
    }

    public boolean isBound() {
        return this.acceptor.isManaged((SocketAddress)this.getBindAddress());
    }
}

