/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.NettyEventLoopFactory;
import org.apache.dubbo.remoting.api.SslContexts;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.AbstractPortUnificationServer;
import org.apache.dubbo.remoting.transport.netty4.NettyPortUnificationServerHandler;
import org.apache.dubbo.rpc.model.ScopeModel;

public class NettyPortUnificationServer
extends AbstractPortUnificationServer {
    private static final Logger logger = LoggerFactory.getLogger(NettyPortUnificationServer.class);
    private final DefaultChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final int serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.getUrl().getOrDefaultModuleModel());
    private ServerBootstrap bootstrap;
    private io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public NettyPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    public void close() {
        if (this.channel != null) {
            this.doClose();
        }
    }

    public void bind() {
        if (this.channel == null) {
            this.doOpen();
        }
    }

    public void doOpen() {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup((int)1, (String)"NettyServerBoss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup((int)this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), (String)"NettyServerWorker");
        boolean enableSsl = this.getUrl().getParameter("ssl-enabled", false);
        final SslContext sslContext = enableSsl ? SslContexts.buildServerSslContext((URL)this.getUrl()) : null;
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                NettyPortUnificationServerHandler puHandler = new NettyPortUnificationServerHandler(NettyPortUnificationServer.this.getUrl(), sslContext, true, NettyPortUnificationServer.this.getProtocols(), (ChannelGroup)NettyPortUnificationServer.this.channels, (ChannelHandler)NettyPortUnificationServer.this);
                p.addLast("negotiation-protocol", (io.netty.channel.ChannelHandler)puHandler);
            }
        });
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (this.getUrl().getParameter("anyhost", false) || NetUtils.isInvalidLocalHost((String)bindIp)) {
            bindIp = "0.0.0.0";
        }
        InetSocketAddress bindAddress = new InetSocketAddress(bindIp, bindPort);
        ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)bindAddress);
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    public void doClose() {
        long st = System.currentTimeMillis();
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.channels.close().await((long)this.serverShutdownTimeoutMills);
            long cost = System.currentTimeMillis() - st;
            logger.info("Port unification server closed. cost:" + cost);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while shutting down", (Throwable)e);
        }
        for (WireProtocol protocol : this.getProtocols()) {
            protocol.close();
        }
        try {
            if (this.bootstrap != null) {
                long timeout = this.serverShutdownTimeoutMills;
                long quietPeriod = Math.min(2000L, timeout);
                Future bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                Future workerGroupShutdownFuture = this.workerGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
                workerGroupShutdownFuture.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public Collection<Channel> getChannels() {
        return null;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }
}

