/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.NettyEventLoopFactory;
import org.apache.dubbo.remoting.api.SslClientTlsHandler;
import org.apache.dubbo.remoting.transport.AbstractClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyClientHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyCodecAdapter;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.ScopeModel;

public class NettyClient
extends AbstractClient {
    private static final String SOCKS_PROXY_HOST = "socksProxyHost";
    private static final String SOCKS_PROXY_PORT = "socksProxyPort";
    private static final String DEFAULT_SOCKS_PROXY_PORT = "1080";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyClient.class);
    private static final GlobalResourceInitializer<EventLoopGroup> EVENT_LOOP_GROUP = new GlobalResourceInitializer(() -> NettyEventLoopFactory.eventLoopGroup((int)Constants.DEFAULT_IO_THREADS, (String)"NettyClientWorker"), EventExecutorGroup::shutdownGracefully);
    private Bootstrap bootstrap;
    private volatile io.netty.channel.Channel channel;

    public NettyClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, NettyClient.wrapChannelHandler((URL)url, (ChannelHandler)handler));
    }

    protected void doOpen() throws Throwable {
        NettyClientHandler nettyClientHandler = this.createNettyClientHandler();
        this.bootstrap = new Bootstrap();
        this.initBootstrap(nettyClientHandler);
    }

    protected NettyClientHandler createNettyClientHandler() {
        return new NettyClientHandler(this.getUrl(), (ChannelHandler)this);
    }

    protected void initBootstrap(final NettyClientHandler nettyClientHandler) {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)EVENT_LOOP_GROUP.get())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).channel(NettyEventLoopFactory.socketChannelClass());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.max(3000, this.getConnectTimeout()));
        this.bootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                int heartbeatInterval = UrlUtils.getHeartbeat((URL)NettyClient.this.getUrl());
                if (NettyClient.this.getUrl().getParameter("ssl-enabled", false)) {
                    ch.pipeline().addLast("negotiation", (io.netty.channel.ChannelHandler)new SslClientTlsHandler(NettyClient.this.getUrl()));
                }
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyClient.this.getCodec(), NettyClient.this.getUrl(), (ChannelHandler)NettyClient.this);
                ch.pipeline().addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("client-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler((long)heartbeatInterval, 0L, 0L, TimeUnit.MILLISECONDS)).addLast("handler", (io.netty.channel.ChannelHandler)nettyClientHandler);
                String socksProxyHost = ConfigurationUtils.getProperty((ScopeModel)NettyClient.this.getUrl().getOrDefaultApplicationModel(), (String)NettyClient.SOCKS_PROXY_HOST);
                if (socksProxyHost != null && !NettyClient.this.isFilteredAddress(NettyClient.this.getUrl().getHost())) {
                    int socksProxyPort = Integer.parseInt(ConfigurationUtils.getProperty((ScopeModel)NettyClient.this.getUrl().getOrDefaultApplicationModel(), (String)NettyClient.SOCKS_PROXY_PORT, (String)NettyClient.DEFAULT_SOCKS_PROXY_PORT));
                    Socks5ProxyHandler socks5ProxyHandler = new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(socksProxyHost, socksProxyPort));
                    ch.pipeline().addFirst(new io.netty.channel.ChannelHandler[]{socks5ProxyHandler});
                }
            }
        });
    }

    private boolean isFilteredAddress(String host) {
        return StringUtils.isEquals((String)NetUtils.getLocalHost(), (String)host) || NetUtils.isLocalHost((String)host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doConnect() throws Throwable {
        try {
            ipv6Address = NetUtils.getLocalHostV6();
            if (ipv6Address == null || this.getUrl().getParameter("ipv6") == null) ** GOTO lbl-1000
            connectAddress = new InetSocketAddress(this.getUrl().getParameter("ipv6"), this.getUrl().getPort());
            try {
                this.doConnect(connectAddress);
                return;
            }
            catch (Throwable var3_3) {
                connectAddress = this.getConnectAddress();
                this.doConnect(connectAddress);
            }
        }
        finally {
            if (!this.isConnected()) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect(InetSocketAddress serverAddress) throws RemotingException {
        block21: {
            long start = System.currentTimeMillis();
            ChannelFuture future = this.bootstrap.connect((SocketAddress)serverAddress);
            try {
                boolean ret = future.awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
                if (ret && future.isSuccess()) {
                    io.netty.channel.Channel newChannel = future.channel();
                    try {
                        io.netty.channel.Channel oldChannel = this.channel;
                        if (oldChannel == null) break block21;
                        try {
                            if (logger.isInfoEnabled()) {
                                logger.info("Close old netty channel " + oldChannel + " on create new netty channel " + newChannel);
                            }
                            oldChannel.close();
                            break block21;
                        }
                        finally {
                            NettyChannel.removeChannelIfDisconnected(oldChannel);
                        }
                    }
                    finally {
                        if (this.isClosed()) {
                            try {
                                if (logger.isInfoEnabled()) {
                                    logger.info("Close new netty channel " + newChannel + ", because the client closed.");
                                }
                                newChannel.close();
                            }
                            finally {
                                this.channel = null;
                                NettyChannel.removeChannelIfDisconnected(newChannel);
                            }
                        } else {
                            this.channel = newChannel;
                        }
                    }
                }
                if (future.cause() != null) {
                    Throwable cause = future.cause();
                    RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + serverAddress + ", error message is:" + cause.getMessage(), cause);
                    logger.error("6-1", "network disconnected", "", "Failed to connect to provider server by other reason.", cause);
                    throw remotingException;
                }
                RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + serverAddress + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
                logger.error("6-2", "provider crash", "", "Client-side timeout.", (Throwable)remotingException);
                throw remotingException;
            }
            finally {
                if (!this.isConnected()) {
                    // empty if block
                }
            }
        }
    }

    protected void doDisConnect() throws Throwable {
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Throwable t) {
            logger.warn("6-5", "", "", t.getMessage());
        }
    }

    protected void doClose() throws Throwable {
    }

    protected Channel getChannel() {
        io.netty.channel.Channel c = this.channel;
        if (c == null) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), (ChannelHandler)this);
    }

    io.netty.channel.Channel getNettyChannel() {
        return this.channel;
    }

    public boolean canHandleIdle() {
        return true;
    }

    protected EventLoopGroup getEventLoopGroup() {
        return (EventLoopGroup)EVENT_LOOP_GROUP.get();
    }

    protected Bootstrap getBootstrap() {
        return this.bootstrap;
    }
}

