/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.transport.netty4.AddressUtils;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

public class NettyChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyChannelHandler.class);
    private final Map<String, Channel> dubboChannels;
    private final URL url;
    private final ChannelHandler handler;

    public NettyChannelHandler(Map<String, Channel> dubboChannels, URL url, ChannelHandler handler) {
        this.dubboChannels = dubboChannels;
        this.url = url;
        this.handler = handler;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        io.netty.channel.Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        if (channel != null) {
            this.dubboChannels.put(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ch.remoteAddress())), (Channel)channel);
            this.handler.connected((Channel)channel);
            if (logger.isInfoEnabled()) {
                logger.info("The connection {} of {} -> {} is established.", new Object[]{ch, AddressUtils.getRemoteAddressKey(ch), AddressUtils.getLocalAddressKey(ch)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        io.netty.channel.Channel ch = ctx.channel();
        NettyChannel channel = NettyChannel.getOrAddChannel(ch, this.url, this.handler);
        try {
            this.dubboChannels.remove(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ch.remoteAddress())));
            if (channel != null) {
                this.handler.disconnected((Channel)channel);
                if (logger.isInfoEnabled()) {
                    logger.info("The connection {} of {} -> {} is disconnected.", new Object[]{ch, AddressUtils.getRemoteAddressKey(ch), AddressUtils.getLocalAddressKey(ch)});
                }
            }
        }
        finally {
            NettyChannel.removeChannel(ch);
        }
    }
}

