/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.ssl.CertManager;
import org.apache.dubbo.common.ssl.ProviderCert;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.transport.netty4.NettyBackedChannelBuffer;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyConfigOperator;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;

public class NettyPortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(NettyPortUnificationServerHandler.class);
    private final URL url;
    private final ChannelHandler handler;
    private final boolean detectSsl;
    private final Map<String, WireProtocol> protocols;
    private final Map<String, URL> urlMapper;
    private final Map<String, ChannelHandler> handlerMapper;

    public NettyPortUnificationServerHandler(URL url, boolean detectSsl, Map<String, WireProtocol> protocols, ChannelHandler handler, Map<String, URL> urlMapper, Map<String, ChannelHandler> handlerMapper) {
        this.url = url;
        this.protocols = protocols;
        this.detectSsl = detectSsl;
        this.handler = handler;
        this.urlMapper = urlMapper;
        this.handlerMapper = handlerMapper;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("99-0", "unknown error in remoting module", "", "Unexpected exception from downstream before protocol detected.", cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            if (handshakeEvent.isSuccess()) {
                SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                LOGGER.info("TLS negotiation succeed with session: " + session);
            } else {
                LOGGER.error("99-0", "", "", "TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                ctx.close();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        if (in.readableBytes() < 2) {
            return;
        }
        CertManager certManager = (CertManager)this.url.getOrDefaultFrameworkModel().getBeanFactory().getBean(CertManager.class);
        ProviderCert providerConnectionConfig = certManager.getProviderConnectionConfig(this.url, ctx.channel().remoteAddress());
        if (providerConnectionConfig != null && this.isSsl(in)) {
            this.enableSsl(ctx, providerConnectionConfig);
        } else {
            this.detectProtocol(ctx, this.url, channel, in);
        }
    }

    private void enableSsl(ChannelHandlerContext ctx, ProviderCert providerConnectionConfig) {
        ChannelPipeline p = ctx.pipeline();
        SslContext sslContext = SslContexts.buildServerSslContext(providerConnectionConfig);
        p.addLast("ssl", (io.netty.channel.ChannelHandler)sslContext.newHandler(ctx.alloc()));
        p.addLast("unificationA", (io.netty.channel.ChannelHandler)new NettyPortUnificationServerHandler(this.url, false, this.protocols, this.handler, this.urlMapper, this.handlerMapper));
        p.addLast("ALPN", (io.netty.channel.ChannelHandler)new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
                if (!"h2".equals(protocol)) {
                    return;
                }
                NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), NettyPortUnificationServerHandler.this.url, NettyPortUnificationServerHandler.this.handler);
                ByteBuf in = ctx.alloc().buffer();
                NettyPortUnificationServerHandler.this.detectProtocol(ctx, NettyPortUnificationServerHandler.this.url, channel, in);
            }
        });
        p.remove((io.netty.channel.ChannelHandler)this);
    }

    private boolean isSsl(ByteBuf buf) {
        if (this.detectSsl && buf.readableBytes() >= 5) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        return false;
    }

    private void detectProtocol(ChannelHandlerContext ctx, URL url, NettyChannel channel, ByteBuf in) {
        HashSet<String> supportedProtocolNames = new HashSet<String>(this.protocols.keySet());
        supportedProtocolNames.retainAll(this.urlMapper.keySet());
        block5: for (String name : supportedProtocolNames) {
            WireProtocol protocol = this.protocols.get(name);
            in.markReaderIndex();
            NettyBackedChannelBuffer buf = new NettyBackedChannelBuffer(in);
            ProtocolDetector.Result result = protocol.detector().detect((ChannelBuffer)buf);
            in.resetReaderIndex();
            switch (result.flag()) {
                case UNRECOGNIZED: {
                    continue block5;
                }
                case RECOGNIZED: {
                    ChannelHandler localHandler = this.handlerMapper.getOrDefault(name, this.handler);
                    URL localURL = this.urlMapper.getOrDefault(name, url);
                    channel.setUrl(localURL);
                    NettyConfigOperator operator = new NettyConfigOperator(channel, localHandler);
                    operator.setDetectResult(result);
                    protocol.configServerProtocolHandler(url, (ChannelOperator)operator);
                    ctx.pipeline().remove((io.netty.channel.ChannelHandler)this);
                }
                case NEED_MORE_DATA: {
                    return;
                }
            }
            return;
        }
        byte[] preface = new byte[in.readableBytes()];
        in.readBytes(preface);
        Set supported = url.getApplicationModel().getExtensionLoader(WireProtocol.class).getSupportedExtensions();
        LOGGER.error("99-0", "unknown error in remoting module", "", String.format("Can not recognize protocol from downstream=%s . preface=%s protocols=%s", ctx.channel().remoteAddress(), Bytes.bytes2hex((byte[])preface), supported));
        in.clear();
        ctx.close();
    }
}

