/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.transport.netty4.ChannelAddressAccessor;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class AddressUtils {
    private static final List<ChannelAddressAccessor> ACCESSORS = FrameworkModel.defaultModel().getActivateExtensions(ChannelAddressAccessor.class);

    private AddressUtils() {
    }

    public static InetSocketAddress getRemoteAddress(Channel channel) {
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress address = ACCESSORS.get(i).getRemoteAddress(channel);
            if (address == null) continue;
            return address;
        }
        return (InetSocketAddress)channel.remoteAddress();
    }

    public static InetSocketAddress getLocalAddress(Channel channel) {
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress address = ACCESSORS.get(i).getLocalAddress(channel);
            if (address == null) continue;
            return address;
        }
        return (InetSocketAddress)channel.localAddress();
    }

    public static String getRemoteAddressKey(Channel channel) {
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            ChannelAddressAccessor accessor = ACCESSORS.get(i);
            InetSocketAddress address = accessor.getRemoteAddress(channel);
            if (address == null) continue;
            return accessor.getProtocol() + ' ' + NetUtils.toAddressString((InetSocketAddress)address);
        }
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (remoteAddress == null) {
            return "UNKNOWN";
        }
        return NetUtils.toAddressString((InetSocketAddress)remoteAddress);
    }

    public static String getLocalAddressKey(Channel channel) {
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            ChannelAddressAccessor accessor = ACCESSORS.get(i);
            InetSocketAddress address = accessor.getLocalAddress(channel);
            if (address == null) continue;
            return accessor.getProtocol() + ' ' + NetUtils.toAddressString((InetSocketAddress)address);
        }
        SocketAddress localAddress = channel.localAddress();
        if (localAddress == null) {
            return "UNKNOWN";
        }
        return NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)localAddress));
    }
}

