/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.p2p.support;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.p2p.Peer;
import org.apache.dubbo.remoting.p2p.support.AbstractGroup;

public class MulticastGroup
extends AbstractGroup {
    private static final String JOIN = "join";
    private static final String LEAVE = "leave";
    private InetAddress multicastAddress;
    private MulticastSocket multicastSocket;

    public MulticastGroup(URL url) {
        super(url);
        if (!NetUtils.isMulticastAddress((String)url.getHost())) {
            throw new IllegalArgumentException("Invalid multicast address " + url.getHost() + ", scope: 224.0.0.0 - 239.255.255.255");
        }
        try {
            this.multicastAddress = InetAddress.getByName(url.getHost());
            this.multicastSocket = new MulticastSocket(url.getPort());
            this.multicastSocket.setLoopbackMode(false);
            this.multicastSocket.joinGroup(this.multicastAddress);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] buf = new byte[1024];
                    DatagramPacket recv = new DatagramPacket(buf, buf.length);
                    while (true) {
                        try {
                            while (true) {
                                MulticastGroup.this.multicastSocket.receive(recv);
                                MulticastGroup.this.receive(new String(recv.getData()).trim(), (InetSocketAddress)recv.getSocketAddress());
                            }
                        }
                        catch (Exception e) {
                            AbstractGroup.logger.error(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            }, "MulticastGroupReceiver");
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void send(String msg) throws RemotingException {
        DatagramPacket hi = new DatagramPacket(msg.getBytes(), msg.length(), this.multicastAddress, this.multicastSocket.getLocalPort());
        try {
            this.multicastSocket.send(hi);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void receive(String msg, InetSocketAddress remoteAddress) throws RemotingException {
        if (msg.startsWith(JOIN)) {
            String url = msg.substring(JOIN.length()).trim();
            this.connect(URL.valueOf((String)url));
        } else if (msg.startsWith(LEAVE)) {
            String url = msg.substring(LEAVE.length()).trim();
            this.disconnect(URL.valueOf((String)url));
        }
    }

    @Override
    public Peer join(URL url, ChannelHandler handler) throws RemotingException {
        Peer peer = super.join(url, handler);
        this.send("join " + url.toFullString());
        return peer;
    }

    @Override
    public void leave(URL url) throws RemotingException {
        super.leave(url);
        this.send("leave " + url.toFullString());
    }
}

