/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

final class BeanArgumentBinder {
    private final ArgumentResolver argumentResolver;
    private final Map<Pair<Class<?>, String>, BeanMeta> cache = CollectionUtils.newConcurrentHashMap();

    BeanArgumentBinder(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.argumentResolver = (ArgumentResolver)beanFactory.getOrRegisterBean(CompositeArgumentResolver.class);
    }

    public Object bind(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        try {
            return this.resolveArgument(parameter, request, response);
        }
        catch (Exception e) {
            throw new RestException(Messages.ARGUMENT_BIND_ERROR, new Object[]{parameter.getName(), parameter.getType(), e});
        }
    }

    private Object resolveArgument(ParameterMeta param, HttpRequest request, HttpResponse response) throws Exception {
        AnnotationMeta form = param.findAnnotation((AnnotationEnum)Annotations.Form);
        if (form != null || param.isHierarchyAnnotated((AnnotationEnum)Annotations.BeanParam)) {
            String prefix = form == null ? null : form.getString("prefix");
            BeanMeta beanMeta = this.cache.computeIfAbsent(Pair.of((Object)param.getActualType(), (Object)prefix), k -> new BeanMeta(param.getToolKit(), (String)k.getValue(), (Class)k.getKey()));
            ConstructorMeta constructor = beanMeta.constructor;
            ConstructorParameterMeta[] parameters = constructor.parameters;
            int len = parameters.length;
            Object[] args = new Object[len];
            for (int i = 0; i < len; ++i) {
                args[i] = this.resolveArgument(parameters[i], request, response);
            }
            Object bean = constructor.newInstance(args);
            for (FieldMeta fieldMeta : beanMeta.fields) {
                fieldMeta.set(bean, this.resolveArgument(fieldMeta, request, response));
            }
            for (SetMethodMeta methodMeta : beanMeta.methods) {
                methodMeta.invoke(bean, this.resolveArgument(methodMeta, request, response));
            }
            return bean;
        }
        return this.argumentResolver.resolve(param, request, response);
    }

    private static class BeanMeta {
        private final List<FieldMeta> fields = new ArrayList<FieldMeta>();
        private final List<SetMethodMeta> methods = new ArrayList<SetMethodMeta>();
        private final ConstructorMeta constructor;

        BeanMeta(RestToolKit toolKit, String prefix, Class<?> type) {
            this.constructor = this.resolveConstructor(toolKit, prefix, type);
            this.resolveFieldAndMethod(toolKit, prefix, type);
        }

        private ConstructorMeta resolveConstructor(RestToolKit toolKit, String prefix, Class<?> type) {
            Constructor<?>[] constructors = type.getConstructors();
            Constructor<?> ct = null;
            if (constructors.length == 1) {
                ct = constructors[0];
            } else {
                try {
                    ct = type.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (ct == null) {
                throw new IllegalArgumentException("No available default constructor found in " + type);
            }
            return new ConstructorMeta(toolKit, prefix, ct);
        }

        private void resolveFieldAndMethod(RestToolKit toolKit, String prefix, Class<?> type) {
            int modifiers;
            if (type == Object.class) {
                return;
            }
            for (Field field : type.getDeclaredFields()) {
                modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || field.getAnnotations().length == 0) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                this.fields.add(new FieldMeta(toolKit, prefix, field));
            }
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterCount() != 1 || ((modifiers = ((Method)accessibleObject).getModifiers()) & 0x409) != 1) continue;
                Parameter parameter = ((Executable)accessibleObject).getParameters()[0];
                String name = ((Method)accessibleObject).getName();
                if (name.length() <= 3 || !name.startsWith("set")) continue;
                name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                this.methods.add(new SetMethodMeta(toolKit, (Method)accessibleObject, parameter, prefix, name));
            }
            this.resolveFieldAndMethod(toolKit, prefix, type.getSuperclass());
        }
    }

    private static final class ConstructorMeta {
        private final Constructor<?> constructor;
        private final ConstructorParameterMeta[] parameters;

        ConstructorMeta(RestToolKit toolKit, String prefix, Constructor<?> constructor) {
            this.constructor = constructor;
            this.parameters = this.initParameters(toolKit, prefix, constructor);
        }

        private ConstructorParameterMeta[] initParameters(RestToolKit toolKit, String prefix, Constructor<?> ct) {
            Parameter[] cps = ct.getParameters();
            int len = cps.length;
            ConstructorParameterMeta[] parameters = new ConstructorParameterMeta[len];
            for (int i = 0; i < len; ++i) {
                parameters[i] = new ConstructorParameterMeta(toolKit, cps[i], prefix);
            }
            return parameters;
        }

        Object newInstance(Object[] args) throws Exception {
            return this.constructor.newInstance(args);
        }
    }

    public static final class ConstructorParameterMeta
    extends ParameterMeta {
        private final Parameter parameter;

        ConstructorParameterMeta(RestToolKit toolKit, Parameter parameter, String prefix) {
            super(toolKit, prefix, parameter.isNamePresent() ? parameter.getName() : null);
            this.parameter = parameter;
        }

        protected AnnotatedElement getAnnotatedElement() {
            return this.parameter;
        }

        public Class<?> getType() {
            return this.parameter.getType();
        }

        public Type getGenericType() {
            return this.parameter.getParameterizedType();
        }

        public String getDescription() {
            return "ConstructorParameter{" + this.parameter + '}';
        }
    }

    private static final class FieldMeta
    extends ParameterMeta {
        private final Field field;

        FieldMeta(RestToolKit toolKit, String prefix, Field field) {
            super(toolKit, prefix, field.getName());
            this.field = field;
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public Type getGenericType() {
            return this.field.getGenericType();
        }

        protected AnnotatedElement getAnnotatedElement() {
            return this.field;
        }

        public void set(Object bean, Object value) throws Exception {
            this.field.set(bean, value);
        }

        public String getDescription() {
            return "FieldParameter{" + this.field + '}';
        }
    }

    private static final class SetMethodMeta
    extends ParameterMeta {
        private final Method method;
        private final Parameter parameter;

        SetMethodMeta(RestToolKit toolKit, Method method, Parameter parameter, String prefix, String name) {
            super(toolKit, prefix, name);
            this.method = method;
            this.parameter = parameter;
        }

        public Class<?> getType() {
            return this.parameter.getType();
        }

        public Type getGenericType() {
            return this.parameter.getParameterizedType();
        }

        protected AnnotatedElement getAnnotatedElement() {
            return this.parameter;
        }

        public void invoke(Object bean, Object value) throws Exception {
            this.method.invoke(bean, value);
        }

        public String getDescription() {
            return "SetMethodParameter{" + this.method + '}';
        }
    }
}

