/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.AbstractJaxrsArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;

@Activate(onClass={"javax.ws.rs.CookieParam"})
public class CookieParamArgumentResolver
extends AbstractJaxrsArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.CookieParam.type();
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return request.cookie(meta.name());
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Collection cookies = request.cookies();
        if (cookies.isEmpty()) {
            return Collections.emptyList();
        }
        String name = meta.name();
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>(cookies.size());
        for (HttpCookie cookie : cookies) {
            if (!name.equals(cookie.name())) continue;
            result.add(cookie);
        }
        return result;
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Collection cookies = request.cookies();
        if (cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        Map mapValue = CollectionUtils.newLinkedHashMap((int)cookies.size());
        for (HttpCookie cookie : cookies) {
            mapValue.computeIfAbsent(cookie.name(), k -> new ArrayList()).add(cookie);
        }
        return mapValue;
    }
}

