/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AbstractArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(order=2147473647, onClass={"javax.ws.rs.Path"})
public class FallbackArgumentResolver
extends AbstractArgumentResolver {
    public boolean accept(ParameterMeta param) {
        return param.getToolKit().getDialect() == 2;
    }

    protected NamedValueMeta createNamedValueMeta(ParameterMeta param) {
        return new NamedValueMeta(param.isAnnotated((AnnotationEnum)Annotations.Nonnull), Helper.defaultValue(param));
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Object value = RequestUtils.decodeBody((HttpRequest)request, (Class)meta.type());
        if (value != null) {
            return value;
        }
        if (meta.parameterMeta().isSimple()) {
            return request.parameter(meta.name());
        }
        return null;
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Class type = meta.type();
        if (type == byte[].class) {
            try {
                return StreamUtils.readBytes((InputStream)request.inputStream());
            }
            catch (IOException e) {
                throw new RestException((Throwable)e);
            }
        }
        Object value = RequestUtils.decodeBody((HttpRequest)request, (Class)meta.type());
        if (value != null) {
            return value;
        }
        if (TypeUtils.isSimpleProperty((Class)meta.nestedType(0))) {
            return request.parameterValues(meta.name());
        }
        return null;
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Object value = RequestUtils.decodeBody((HttpRequest)request, (Class)meta.type());
        if (value != null) {
            return value;
        }
        if (TypeUtils.isSimpleProperty((Class)meta.nestedType(1))) {
            return RequestUtils.getParametersMap((HttpRequest)request);
        }
        return null;
    }
}

