/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.AbstractJaxrsArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;

@Activate(onClass={"javax.ws.rs.FormParam"})
public class FormParamArgumentResolver
extends AbstractJaxrsArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.FormParam.type();
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return CollectionUtils.first((List)request.formParameterValues(this.getFullName(meta)));
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return request.formParameterValues(this.getFullName(meta));
    }

    private String getFullName(NamedValueMeta meta) {
        String prefix = meta.parameterMeta().getPrefix();
        return prefix == null ? meta.name() : prefix + '.' + meta.name();
    }
}

