/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.filter;

import io.netty.handler.codec.DateFormatter;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.MultivaluedMapWrapper;

final class ContainerResponseContextImpl
implements ContainerResponseContext {
    private final HttpRequest request;
    private final HttpResponse response;
    private final Result result;
    private MultivaluedMap<String, String> headers;

    public ContainerResponseContextImpl(HttpRequest request, HttpResponse response, Result result) {
        this.request = request;
        this.response = response;
        this.result = result;
    }

    public int getStatus() {
        return this.response.status();
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public Response.StatusType getStatusInfo() {
        return Response.Status.fromStatusCode((int)this.response.status());
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.response.setStatus(statusInfo.getStatusCode());
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.getStringHeaders();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        Object headers = this.headers;
        if (headers == null) {
            this.headers = headers = new MultivaluedMapWrapper(this.response.headers());
        }
        return headers;
    }

    public String getHeaderString(String name) {
        return this.response.header(name);
    }

    public Set<String> getAllowedMethods() {
        return Collections.singleton(this.request.method());
    }

    public Date getDate() {
        return null;
    }

    public Locale getLanguage() {
        return HttpUtils.parseLocale((String)this.response.locale());
    }

    public int getLength() {
        return -1;
    }

    public MediaType getMediaType() {
        return Helper.toMediaType(this.response.mediaType());
    }

    public Map<String, NewCookie> getCookies() {
        Collection cookies = this.request.cookies();
        HashMap<String, NewCookie> result = new HashMap<String, NewCookie>(cookies.size());
        for (HttpCookie cookie : cookies) {
            result.put(cookie.name(), Helper.convert(cookie));
        }
        return result;
    }

    public EntityTag getEntityTag() {
        return null;
    }

    public Date getLastModified() {
        String value = this.response.header("last-modified");
        return value == null ? null : DateFormatter.parseHttpDate((CharSequence)value);
    }

    public URI getLocation() {
        String location = this.response.header("location");
        return location == null ? null : URI.create(location);
    }

    public Set<Link> getLinks() {
        return null;
    }

    public boolean hasLink(String relation) {
        return false;
    }

    public Link getLink(String relation) {
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return null;
    }

    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    public Object getEntity() {
        return this.result.getValue();
    }

    public Class<?> getEntityClass() {
        return this.getHandler().getMethod().getReturnType();
    }

    public Type getEntityType() {
        return this.getHandler().getMethod().getGenericReturnType();
    }

    public void setEntity(Object entity) {
        this.result.setValue(entity);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.result.setValue(entity);
        this.response.setContentType(Helper.toString(mediaType));
    }

    public Annotation[] getEntityAnnotations() {
        return new Annotation[0];
    }

    public OutputStream getEntityStream() {
        return this.response.outputStream();
    }

    public void setEntityStream(OutputStream outputStream) {
        this.response.setOutputStream(outputStream);
    }

    private HandlerMeta getHandler() {
        return (HandlerMeta)this.request.attribute(RestConstants.HANDLER_ATTRIBUTE);
    }
}

