/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.MultivaluedMapWrapper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ResteasyUriInfo;

@Activate(onClass={"javax.ws.rs.Path"})
public class JaxrsMiscArgumentResolver
implements ArgumentResolver {
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();

    public boolean accept(ParameterMeta parameter) {
        return SUPPORTED_TYPES.contains(parameter.getActualType());
    }

    public Object resolve(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        Class type = parameter.getActualType();
        if (Cookie.class.isAssignableFrom(type)) {
            return Helper.convert(request.cookie(parameter.getRequiredName()));
        }
        if (Form.class.isAssignableFrom(type)) {
            return RequestUtils.getFormParametersMap((HttpRequest)request);
        }
        if (HttpHeaders.class.isAssignableFrom(type)) {
            return new ResteasyHttpHeaders(new MultivaluedMapWrapper(request.headers()));
        }
        if (MediaType.class.isAssignableFrom(type)) {
            return Helper.toMediaType(request.mediaType());
        }
        if (MultivaluedMap.class.isAssignableFrom(type)) {
            return new MultivaluedMapWrapper(RequestUtils.getParametersMap((HttpRequest)request));
        }
        if (UriInfo.class.isAssignableFrom(type)) {
            return new ResteasyUriInfo(request.rawPath(), request.query(), "/");
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(Cookie.class);
        SUPPORTED_TYPES.add(Form.class);
        SUPPORTED_TYPES.add(HttpHeaders.class);
        SUPPORTED_TYPES.add(MediaType.class);
        SUPPORTED_TYPES.add(MultivaluedMap.class);
        SUPPORTED_TYPES.add(UriInfo.class);
    }
}

