/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.cors.CorsUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ServiceVersionCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.JaxrsRestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

@Activate(onClass={"javax.ws.rs.Path"})
public class JaxrsRequestMappingResolver
implements RequestMappingResolver {
    private final FrameworkModel frameworkModel;
    private final RestToolKit toolKit;
    private CorsMeta globalCorsMeta;

    public JaxrsRequestMappingResolver(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.toolKit = new JaxrsRestToolKit(frameworkModel);
    }

    public RestToolKit getRestToolKit() {
        return this.toolKit;
    }

    public RequestMapping resolve(ServiceMeta serviceMeta) {
        AnnotationMeta path = serviceMeta.findAnnotation((AnnotationEnum)Annotations.Path);
        if (path == null) {
            return null;
        }
        return this.builder((AnnotationSupport)serviceMeta, path, null).name(serviceMeta.getType().getSimpleName()).contextPath(serviceMeta.getContextPath()).build();
    }

    public RequestMapping resolve(MethodMeta methodMeta) {
        AnnotationMeta path = methodMeta.findAnnotation((AnnotationEnum)Annotations.Path);
        if (path == null) {
            return null;
        }
        AnnotationMeta httpMethod = methodMeta.findMergedAnnotation((AnnotationEnum)Annotations.HttpMethod);
        if (httpMethod == null) {
            return null;
        }
        ServiceMeta serviceMeta = methodMeta.getServiceMeta();
        if (this.globalCorsMeta == null) {
            this.globalCorsMeta = CorsUtils.getGlobalCorsMeta((FrameworkModel)this.frameworkModel);
        }
        return this.builder((AnnotationSupport)methodMeta, path, httpMethod).name(methodMeta.getMethod().getName()).contextPath(methodMeta.getServiceMeta().getContextPath()).custom((Condition)new ServiceVersionCondition(serviceMeta.getServiceGroup(), serviceMeta.getServiceVersion())).cors(this.globalCorsMeta).build();
    }

    private RequestMapping.Builder builder(AnnotationSupport meta, AnnotationMeta<?> path, AnnotationMeta<?> httpMethod) {
        AnnotationMeta consumes;
        AnnotationMeta produces;
        RequestMapping.Builder builder = RequestMapping.builder().path(new String[]{path.getValue()});
        if (httpMethod == null) {
            httpMethod = meta.findMergedAnnotation((AnnotationEnum)Annotations.HttpMethod);
        }
        if (httpMethod != null) {
            builder.method(new String[]{httpMethod.getValue()});
        }
        if ((produces = meta.findAnnotation((AnnotationEnum)Annotations.Produces)) != null) {
            builder.produce(produces.getValueArray());
        }
        if ((consumes = meta.findAnnotation((AnnotationEnum)Annotations.Consumes)) != null) {
            builder.consume(consumes.getValueArray());
        }
        return builder;
    }
}

