/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

final class BeanArgumentBinder {
    private static final ThreadLocal<Set<Class<?>>> LOCAL = new ThreadLocal();
    private final Map<Pair<Class<?>, String>, BeanMeta> cache = CollectionUtils.newConcurrentHashMap();
    private final ArgumentResolver argumentResolver;

    BeanArgumentBinder(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.argumentResolver = (ArgumentResolver)beanFactory.getOrRegisterBean(CompositeArgumentResolver.class);
    }

    public Object bind(ParameterMeta paramMeta, HttpRequest request, HttpResponse response) {
        Set<Class<?>> walked = LOCAL.get();
        if (walked == null) {
            LOCAL.set(new HashSet());
        }
        try {
            Object object = this.resolveArgument(paramMeta, request, response);
            return object;
        }
        catch (Exception e) {
            throw new RestException((Throwable)e, Messages.ARGUMENT_BIND_ERROR, new Object[]{paramMeta.getName(), paramMeta.getType()});
        }
        finally {
            if (walked == null) {
                LOCAL.remove();
            }
        }
    }

    private Object resolveArgument(ParameterMeta paramMeta, HttpRequest request, HttpResponse response) {
        AnnotationMeta form;
        if (paramMeta.isSimple()) {
            return this.argumentResolver.resolve(paramMeta, request, response);
        }
        if (LOCAL.get().add(paramMeta.getActualType()) && ((form = paramMeta.findAnnotation((AnnotationEnum)Annotations.Form)) != null || paramMeta.isHierarchyAnnotated((AnnotationEnum)Annotations.BeanParam))) {
            Object bean;
            String prefix = form == null ? null : form.getString("prefix");
            BeanMeta beanMeta = this.cache.computeIfAbsent(Pair.of((Object)paramMeta.getActualType(), (Object)prefix), k -> new BeanMeta(paramMeta.getToolKit(), (String)k.getValue(), (Class)k.getKey()));
            BeanMeta.ConstructorMeta constructor = beanMeta.getConstructor();
            BeanMeta.ConstructorParameterMeta[] parameters = constructor.getParameters();
            int len = parameters.length;
            if (len == 0) {
                bean = constructor.newInstance(new Object[0]);
            } else {
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    args[i] = this.resolveArgument((ParameterMeta)parameters[i], request, response);
                }
                bean = constructor.newInstance(args);
            }
            HashSet<String> resolved = new HashSet<String>();
            for (BeanMeta.FieldMeta fieldMeta : beanMeta.getFields()) {
                resolved.add(fieldMeta.getName());
                fieldMeta.setValue(bean, this.resolveArgument((ParameterMeta)fieldMeta, request, response));
            }
            for (BeanMeta.SetMethodMeta methodMeta : beanMeta.getMethods()) {
                if (resolved.contains(methodMeta.getName())) continue;
                methodMeta.setValue(bean, this.resolveArgument((ParameterMeta)methodMeta, request, response));
            }
            return bean;
        }
        return TypeUtils.nullDefault((Class)paramMeta.getType());
    }
}

