/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.config.spring.extension.SpringExtensionInjector;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.GeneralTypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.BeanArgumentBinder;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.ConfigurationWrapper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.PropertyPlaceholderHelper;

final class SpringRestToolKit
implements RestToolKit {
    private final ConfigurableBeanFactory beanFactory;
    private final PropertyPlaceholderHelper placeholderHelper;
    private final ConfigurationWrapper configuration;
    private final ConversionService conversionService;
    private final TypeConverter typeConverter;
    private final BeanArgumentBinder argumentBinder;
    private final ParameterNameDiscoverer discoverer;

    public SpringRestToolKit(FrameworkModel frameworkModel) {
        ApplicationModel applicationModel = frameworkModel.defaultApplication();
        SpringExtensionInjector injector = SpringExtensionInjector.get((ExtensionAccessor)applicationModel);
        ApplicationContext context = injector.getContext();
        if (context instanceof ConfigurableApplicationContext) {
            this.beanFactory = ((ConfigurableApplicationContext)context).getBeanFactory();
            this.placeholderHelper = null;
            this.configuration = null;
        } else {
            this.beanFactory = null;
            this.placeholderHelper = new PropertyPlaceholderHelper("${", "}", ":", true);
            this.configuration = new ConfigurationWrapper(applicationModel);
        }
        this.conversionService = context != null && context.containsBean("mvcConversionService") ? (ConversionService)context.getBean(ConversionService.class, new Object[]{"mvcConversionService"}) : DefaultConversionService.getSharedInstance();
        this.typeConverter = (TypeConverter)frameworkModel.getBeanFactory().getOrRegisterBean(GeneralTypeConverter.class);
        this.discoverer = new DefaultParameterNameDiscoverer();
        this.argumentBinder = new BeanArgumentBinder(frameworkModel, this.conversionService);
    }

    public int getDialect() {
        return 1;
    }

    public String resolvePlaceholders(String text) {
        if (!RestUtils.hasPlaceholder((String)text)) {
            return text;
        }
        if (this.beanFactory != null) {
            return this.beanFactory.resolveEmbeddedValue(text);
        }
        return this.placeholderHelper.replacePlaceholders(text, (Properties)this.configuration);
    }

    public Object convert(Object value, ParameterMeta parameter) {
        TypeDescriptor sourceType;
        TypeDescriptor targetType = (TypeDescriptor)parameter.getTypeDescriptor();
        if (targetType == null) {
            MethodParameterMeta meta = (MethodParameterMeta)parameter;
            targetType = new TypeDescriptor(new MethodParameter(meta.getMethod(), meta.getIndex()));
            parameter.setTypeDescriptor((Object)targetType);
        }
        if (this.conversionService.canConvert(sourceType = TypeDescriptor.forObject((Object)value), targetType)) {
            return this.conversionService.convert(value, sourceType, targetType);
        }
        return this.typeConverter.convert(value, parameter.getGenericType());
    }

    public Object bind(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        return this.argumentBinder.bind(parameter, request, response);
    }

    public String[] getParameterNames(Method method) {
        return this.discoverer.getParameterNames(method);
    }

    public Map<String, Object> getAttributes(AnnotatedElement element, Annotation annotation) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)element, annotation.annotationType());
    }
}

