/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AbstractArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(order=2147473647, onClass={"org.springframework.web.bind.annotation.RequestMapping"})
public class FallbackArgumentResolver
extends AbstractArgumentResolver {
    public boolean accept(ParameterMeta param) {
        return param.getToolKit().getDialect() == 1;
    }

    protected NamedValueMeta createNamedValueMeta(ParameterMeta param) {
        return new NamedValueMeta(null, param.isAnnotated((AnnotationEnum)Annotations.Nonnull));
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        ParameterMeta parameter = meta.parameter();
        if (parameter.isStream()) {
            return null;
        }
        if (parameter.isSimple()) {
            return request.parameter(meta.name());
        }
        return parameter.bind(request, response);
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (TypeUtils.isSimpleProperty((Class)meta.nestedType(0))) {
            return request.parameterValues(meta.name());
        }
        return null;
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (TypeUtils.isSimpleProperty((Class)meta.nestedType(1))) {
            return RequestUtils.getParametersMap((HttpRequest)request);
        }
        return null;
    }
}

