/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.springframework.core.SpringVersion;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;

final class Helper {
    public static boolean IS_SPRING_6;
    private static Method getStatusCode;
    private static Method value;

    private Helper() {
    }

    public static boolean isRequired(AnnotationMeta<Annotation> annotation) {
        return annotation.getBoolean("required");
    }

    public static String defaultValue(AnnotationMeta<Annotation> annotation) {
        return Helper.defaultValue(annotation, "defaultValue");
    }

    public static String defaultValue(AnnotationMeta<Annotation> annotation, String name) {
        return Helper.defaultValue(annotation.getString(name));
    }

    public static String defaultValue(String value) {
        return "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(value) ? null : value;
    }

    public static int getStatusCode(ResponseEntity<?> entity) {
        if (IS_SPRING_6) {
            try {
                if (getStatusCode == null) {
                    getStatusCode = ResponseEntity.class.getMethod("getStatusCode", new Class[0]);
                    value = getStatusCode.getReturnType().getMethod("value", new Class[0]);
                }
                return (Integer)value.invoke(getStatusCode.invoke(entity, new Object[0]), new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return entity.getStatusCode().value();
    }

    static {
        try {
            String version = SpringVersion.getVersion();
            IS_SPRING_6 = StringUtils.hasLength((String)version) && version.charAt(0) >= '6';
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

