/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.AbstractSpringArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Helper;

@Activate(onClass={"org.springframework.web.bind.annotation.RequestPart"})
public class RequestPartArgumentResolver
extends AbstractSpringArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.RequestPart.type();
    }

    protected ParamType getParamType(NamedValueMeta meta) {
        return ParamType.Part;
    }

    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param, AnnotationMeta<Annotation> anno) {
        return new NamedValueMeta(anno.getValue(), Helper.isRequired(anno));
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return request.part(meta.name());
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return meta.type() == byte[].class ? request.part(meta.name()) : request.parts();
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Collection parts = request.parts();
        if (parts.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, HttpRequest.FileUpload> result = new LinkedHashMap<String, HttpRequest.FileUpload>(parts.size());
        for (HttpRequest.FileUpload part : parts) {
            result.put(part.name(), part);
        }
        return result;
    }
}

