/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;
import org.apache.dubbo.rpc.support.RpcUtils;

public abstract class AbstractInvoker<T>
implements Invoker<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractInvoker.class);
    private final Class<T> type;
    private final URL url;
    private final Map<String, Object> attachment;
    private volatile boolean available = true;
    private boolean destroyed = false;
    private static final boolean setFutureWhenSync = Boolean.parseBoolean(System.getProperty("future.sync.set", "true"));

    public AbstractInvoker(Class<T> type, URL url) {
        this(type, url, (Map<String, Object>)null);
    }

    public AbstractInvoker(Class<T> type, URL url, String[] keys) {
        this(type, url, AbstractInvoker.convertAttachment(url, keys));
    }

    public AbstractInvoker(Class<T> type, URL url, Map<String, Object> attachment) {
        if (type == null) {
            throw new IllegalArgumentException("service type == null");
        }
        if (url == null) {
            throw new IllegalArgumentException("service url == null");
        }
        this.type = type;
        this.url = url;
        this.attachment = attachment == null ? null : Collections.unmodifiableMap(attachment);
    }

    private static Map<String, Object> convertAttachment(URL url, String[] keys) {
        if (ArrayUtils.isEmpty((Object[])keys)) {
            return null;
        }
        HashMap<String, Object> attachment = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            String value = url.getParameter(key);
            if (value == null || value.length() <= 0) continue;
            attachment.put(key, value);
        }
        return attachment;
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void destroy() {
        this.destroyed = true;
        this.setAvailable(false);
    }

    protected void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        return this.getInterface() + " -> " + (this.getUrl() == null ? "" : this.getUrl().getAddress());
    }

    @Override
    public Result invoke(Invocation inv) throws RpcException {
        if (this.isDestroyed()) {
            logger.warn("Invoker for service " + this + " on consumer " + NetUtils.getLocalHost() + " is destroyed, , dubbo version is " + Version.getVersion() + ", this invoker should not be used any longer");
        }
        RpcInvocation invocation = (RpcInvocation)inv;
        this.prepareInvocation(invocation);
        AsyncRpcResult asyncResult = this.doInvokeAndReturn(invocation);
        this.waitForResultIfSync(asyncResult, invocation);
        return asyncResult;
    }

    private void prepareInvocation(RpcInvocation inv) {
        inv.setInvoker(this);
        this.addInvocationAttachments(inv);
        inv.setInvokeMode(RpcUtils.getInvokeMode(this.url, inv));
        RpcUtils.attachInvocationIdIfAsync(this.getUrl(), inv);
        Byte serializationId = CodecSupport.getIDByName((String)this.getUrl().getParameter("serialization", "hessian2"));
        if (serializationId != null) {
            inv.put("serialization_id", serializationId);
        }
    }

    private void addInvocationAttachments(RpcInvocation invocation) {
        Map<String, Object> clientContextAttachments;
        if (CollectionUtils.isNotEmptyMap(this.attachment)) {
            invocation.addObjectAttachmentsIfAbsent(this.attachment);
        }
        if (CollectionUtils.isNotEmptyMap(clientContextAttachments = RpcContext.getClientAttachment().getObjectAttachments())) {
            invocation.addObjectAttachmentsIfAbsent(clientContextAttachments);
        }
    }

    private AsyncRpcResult doInvokeAndReturn(RpcInvocation invocation) {
        AsyncRpcResult asyncResult;
        try {
            asyncResult = (AsyncRpcResult)this.doInvoke(invocation);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te != null) {
                if (te instanceof RpcException) {
                    ((RpcException)te).setCode(3);
                }
                asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, te, invocation);
            } else {
                asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, e, invocation);
            }
        }
        catch (RpcException e) {
            if (e.isBiz()) {
                asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, e, invocation);
            }
            throw e;
        }
        catch (Throwable e) {
            asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, e, invocation);
        }
        if (setFutureWhenSync || invocation.getInvokeMode() != InvokeMode.SYNC) {
            RpcContext.getServiceContext().setFuture(new FutureAdapter(asyncResult.getResponseFuture()));
        }
        return asyncResult;
    }

    private void waitForResultIfSync(AsyncRpcResult asyncResult, RpcInvocation invocation) {
        if (InvokeMode.SYNC != invocation.getInvokeMode()) {
            return;
        }
        try {
            Object timeout = invocation.getObjectAttachmentWithoutConvert("timeout");
            if (timeout instanceof Integer) {
                asyncResult.get(((Integer)timeout).intValue(), TimeUnit.MILLISECONDS);
            } else {
                asyncResult.get(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RpcException("Interrupted unexpectedly while waiting for remote result to return! method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable rootCause = e.getCause();
            if (rootCause instanceof TimeoutException) {
                throw new RpcException(2, "Invoke remote method timeout. method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), e);
            }
            if (rootCause instanceof RemotingException) {
                throw new RpcException(1, "Failed to invoke remote method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), e);
            }
            throw new RpcException(0, "Fail to invoke remote method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new RpcException(2, "Invoke remote method timeout. method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    protected ExecutorService getCallbackExecutor(URL url, Invocation inv) {
        if (InvokeMode.SYNC == RpcUtils.getInvokeMode(this.getUrl(), inv)) {
            return new ThreadlessExecutor();
        }
        return ((ExecutorRepository)url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).getExecutor(url);
    }

    protected abstract Result doInvoke(Invocation var1) throws Throwable;
}

