/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.proxy.InvocationUtil;

public class InvokerInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(InvokerInvocationHandler.class);
    private final Invoker<?> invoker;
    private ServiceModel serviceModel;
    private URL url;
    private String protocolServiceKey;

    public InvokerInvocationHandler(Invoker<?> handler) {
        this.invoker = handler;
        this.url = this.invoker.getUrl();
        this.protocolServiceKey = this.url.getProtocolServiceKey();
        this.serviceModel = this.url.getServiceModel();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.invoker, args);
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            if ("toString".equals(methodName)) {
                return this.invoker.toString();
            }
            if ("$destroy".equals(methodName)) {
                this.invoker.destroy();
                return null;
            }
            if ("hashCode".equals(methodName)) {
                return this.invoker.hashCode();
            }
        } else if (parameterTypes.length == 1 && "equals".equals(methodName)) {
            return this.invoker.equals(args[0]);
        }
        RpcInvocation rpcInvocation = new RpcInvocation(this.serviceModel, method.getName(), this.invoker.getInterface().getName(), this.protocolServiceKey, method.getParameterTypes(), args);
        if (this.serviceModel instanceof ConsumerModel) {
            rpcInvocation.put("consumerModel", this.serviceModel);
            rpcInvocation.put("methodModel", ((ConsumerModel)this.serviceModel).getMethodModel(method));
        }
        return InvocationUtil.invoke(this.invoker, rpcInvocation);
    }
}

