/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"}, order=0x7FFFFFFF)
public class ClassLoaderCallbackFilter
implements Filter,
BaseFilter.Listener {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        this.setClassLoader(invoker, invocation);
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.setClassLoader(invoker, invocation);
    }

    private void setClassLoader(Invoker<?> invoker, Invocation invocation) {
        ClassLoader workingClassLoader = (ClassLoader)invocation.get("WORKING_CLASSLOADER");
        if (workingClassLoader != null) {
            Thread.currentThread().setContextClassLoader(workingClassLoader);
        }
    }
}

