/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.SerializeSecurityConfigurator;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.model.ServiceModel;

@Activate(order=200)
public class ProtocolSecurityWrapper
implements Protocol {
    private final Protocol protocol;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ProtocolSecurityWrapper.class);

    public ProtocolSecurityWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        try {
            ServiceModel serviceModel = invoker.getUrl().getServiceModel();
            ScopeModel scopeModel = invoker.getUrl().getScopeModel();
            SerializeSecurityConfigurator serializeSecurityConfigurator = (SerializeSecurityConfigurator)ScopeModelUtil.getModuleModel((ScopeModel)scopeModel).getBeanFactory().getBean(SerializeSecurityConfigurator.class);
            serializeSecurityConfigurator.refreshStatus();
            serializeSecurityConfigurator.refreshCheck();
            Optional.ofNullable(invoker.getInterface()).ifPresent(arg_0 -> ((SerializeSecurityConfigurator)serializeSecurityConfigurator).registerInterface(arg_0));
            Optional.ofNullable(serviceModel).map(ServiceModel::getServiceModel).map(ServiceDescriptor::getServiceInterfaceClass).ifPresent(arg_0 -> ((SerializeSecurityConfigurator)serializeSecurityConfigurator).registerInterface(arg_0));
            Optional.ofNullable(serviceModel).map(ServiceModel::getServiceMetadata).map(ServiceMetadata::getServiceType).ifPresent(arg_0 -> ((SerializeSecurityConfigurator)serializeSecurityConfigurator).registerInterface(arg_0));
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Failed to register interface for security check", t);
        }
        return this.protocol.export(invoker);
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        try {
            ServiceModel serviceModel = url.getServiceModel();
            ScopeModel scopeModel = url.getScopeModel();
            SerializeSecurityConfigurator serializeSecurityConfigurator = (SerializeSecurityConfigurator)ScopeModelUtil.getModuleModel((ScopeModel)scopeModel).getBeanFactory().getBean(SerializeSecurityConfigurator.class);
            serializeSecurityConfigurator.refreshStatus();
            serializeSecurityConfigurator.refreshCheck();
            Optional.ofNullable(serviceModel).map(ServiceModel::getServiceModel).map(ServiceDescriptor::getServiceInterfaceClass).ifPresent(arg_0 -> ((SerializeSecurityConfigurator)serializeSecurityConfigurator).registerInterface(arg_0));
            Optional.ofNullable(serviceModel).map(ServiceModel::getServiceMetadata).map(ServiceMetadata::getServiceType).ifPresent(arg_0 -> ((SerializeSecurityConfigurator)serializeSecurityConfigurator).registerInterface(arg_0));
            serializeSecurityConfigurator.registerInterface(type);
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Failed to register interface for security check", t);
        }
        return this.protocol.refer(type, url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }
}

