/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import com.alibaba.dubbo.rpc.service.GenericException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.apache.dubbo.common.beanutil.JavaBeanAccessor;
import org.apache.dubbo.common.beanutil.JavaBeanDescriptor;
import org.apache.dubbo.common.beanutil.JavaBeanSerializeUtil;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.UnsafeByteArrayInputStream;
import org.apache.dubbo.common.io.UnsafeByteArrayOutputStream;
import org.apache.dubbo.common.json.GsonUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

@Activate(group={"provider"}, order=-20000)
public class GenericFilter
implements Filter,
BaseFilter.Listener,
ScopeModelAware {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(GenericFilter.class);
    private ApplicationModel applicationModel;
    private final Map<ClassLoader, Map<String, Class<?>>> classCache = new ConcurrentHashMap();

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        if ((inv.getMethodName().equals("$invoke") || inv.getMethodName().equals("$invokeAsync")) && inv.getArguments() != null && inv.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            String name = ((String)inv.getArguments()[0]).trim();
            String[] types = (String[])inv.getArguments()[1];
            Object[] args = (Object[])inv.getArguments()[2];
            try {
                Method method;
                block51: {
                    method = this.findMethodByMethodSignature(invoker.getInterface(), name, types, inv.getServiceModel());
                    Class[] params = method.getParameterTypes();
                    if (args == null) {
                        args = new Object[params.length];
                    }
                    if (types == null) {
                        types = new String[params.length];
                    }
                    if (args.length != types.length) {
                        throw new RpcException("GenericFilter#invoke args.length != types.length, please check your params");
                    }
                    String generic = inv.getAttachment("generic");
                    if (StringUtils.isBlank((CharSequence)generic)) {
                        generic = this.getGenericValueFromRpcContext();
                    }
                    if (StringUtils.isEmpty((String)generic) || ProtocolUtils.isDefaultGenericSerialization((String)generic) || ProtocolUtils.isGenericReturnRawResult((String)generic)) {
                        try {
                            args = PojoUtils.realize((Object[])args, (Class[])params, (Type[])method.getGenericParameterTypes());
                        }
                        catch (Exception e) {
                            this.logger.error("4-6", "", "", "Deserialize generic invocation failed. ServiceKey: " + inv.getTargetServiceUniqueName(), (Throwable)e);
                            throw new RpcException(e);
                        }
                    }
                    if (ProtocolUtils.isGsonGenericSerialization((String)generic)) {
                        args = this.getGsonGenericArgs(args, method.getGenericParameterTypes());
                    } else if (ProtocolUtils.isJavaGenericSerialization((String)generic)) {
                        CompositeConfiguration configuration = ApplicationModel.ofNullable((ApplicationModel)this.applicationModel).modelEnvironment().getConfiguration();
                        if (!configuration.getBoolean("dubbo.security.serialize.generic.native-java-enable", false)) {
                            String notice = "Trigger the safety barrier! Native Java Serializer is not allowed by default.This means currently maybe being attacking by others. If you are sure this is a mistake, please set `dubbo.security.serialize.generic.native-java-enable` enable in configuration! Before doing so, please make sure you have configure JEP290 to prevent serialization attack.";
                            this.logger.error("5-36", "", "", notice);
                            throw new RpcException(new IllegalStateException(notice));
                        }
                        for (int i = 0; i < args.length; ++i) {
                            if (byte[].class == args[i].getClass()) {
                                try (UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream((byte[])args[i]);){
                                    args[i] = ((Serialization)this.applicationModel.getExtensionLoader(Serialization.class).getExtension("nativejava")).deserialize(null, (InputStream)is).readObject();
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new RpcException("Deserialize argument [" + (i + 1) + "] failed.", (Throwable)e);
                                }
                            }
                            throw new RpcException("Generic serialization [nativejava] only support message type " + byte[].class + " and your message type is " + args[i].getClass());
                        }
                    } else if (ProtocolUtils.isBeanGenericSerialization((String)generic)) {
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i] == null) continue;
                            if (args[i] instanceof JavaBeanDescriptor) {
                                args[i] = JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)((JavaBeanDescriptor)args[i]));
                                continue;
                            }
                            throw new RpcException("Generic serialization [bean] only support message type " + JavaBeanDescriptor.class.getName() + " and your message type is " + args[i].getClass().getName());
                        }
                    } else if (ProtocolUtils.isProtobufGenericSerialization((String)generic)) {
                        if (args.length == 1 && args[0] instanceof String) {
                            try (UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(((String)args[0]).getBytes());){
                                args[0] = ((Serialization)this.applicationModel.getExtensionLoader(Serialization.class).getExtension("protobuf-json")).deserialize(null, (InputStream)is).readObject(method.getParameterTypes()[0]);
                                break block51;
                            }
                            catch (Exception e) {
                                throw new RpcException("Deserialize argument failed.", (Throwable)e);
                            }
                        }
                        throw new RpcException("Generic serialization [protobuf-json] only support one " + String.class.getName() + " argument and your message size is " + args.length + " and type is" + args[0].getClass().getName());
                    }
                }
                RpcInvocation rpcInvocation = new RpcInvocation(inv.getTargetServiceUniqueName(), invoker.getUrl().getServiceModel(), method.getName(), invoker.getInterface().getName(), invoker.getUrl().getProtocolServiceKey(), method.getParameterTypes(), args, inv.getObjectAttachments(), inv.getInvoker(), inv.getAttributes(), inv instanceof RpcInvocation ? ((RpcInvocation)inv).getInvokeMode() : null);
                return invoker.invoke(rpcInvocation);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
        }
        return invoker.invoke(inv);
    }

    private Object[] getGsonGenericArgs(Object[] args, Type[] types) {
        return IntStream.range(0, args.length).mapToObj(i -> {
            if (!(args[i] instanceof String)) {
                throw new RpcException("When using GSON to deserialize generic dubbo request arguments, the arguments must be of type String");
            }
            String str = args[i].toString();
            try {
                return GsonUtils.fromJson((String)str, (Type)types[i]);
            }
            catch (RuntimeException ex) {
                throw new RpcException(ex.getMessage());
            }
        }).toArray();
    }

    private String getGenericValueFromRpcContext() {
        String generic = RpcContext.getServerAttachment().getAttachment("generic");
        if (StringUtils.isBlank((CharSequence)generic)) {
            generic = RpcContext.getClientAttachment().getAttachment("generic");
        }
        return generic;
    }

    public Method findMethodByMethodSignature(Class<?> clazz, String methodName, String[] parameterTypes, ServiceModel serviceModel) throws NoSuchMethodException, ClassNotFoundException {
        Method method;
        if (parameterTypes == null) {
            ArrayList<Method> finded = new ArrayList<Method>();
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equals(methodName)) continue;
                finded.add(m);
            }
            if (finded.isEmpty()) {
                throw new NoSuchMethodException("No such method " + methodName + " in class " + clazz);
            }
            if (finded.size() > 1) {
                String msg = String.format("Not unique method for method name(%s) in class(%s), find %d methods.", methodName, clazz.getName(), finded.size());
                throw new IllegalStateException(msg);
            }
            method = (Method)finded.get(0);
        } else {
            Class[] types = new Class[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                ClassLoader classLoader = ClassUtils.getClassLoader();
                Map<String, Class<?>> cacheMap = this.classCache.get(classLoader);
                if (cacheMap == null) {
                    cacheMap = new ConcurrentHashMap();
                    this.classCache.putIfAbsent(classLoader, cacheMap);
                    cacheMap = this.classCache.get(classLoader);
                }
                types[i] = cacheMap.get(parameterTypes[i]);
                if (types[i] != null) continue;
                types[i] = ReflectUtils.name2class((String)parameterTypes[i]);
                cacheMap.put(parameterTypes[i], types[i]);
            }
            if (serviceModel != null) {
                MethodDescriptor methodDescriptor = serviceModel.getServiceModel().getMethod(methodName, types);
                if (methodDescriptor == null) {
                    throw new NoSuchMethodException("No such method " + methodName + " in class " + clazz);
                }
                method = methodDescriptor.getMethod();
            } else {
                method = clazz.getMethod(methodName, types);
            }
        }
        return method;
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation inv) {
        if ((inv.getMethodName().equals("$invoke") || inv.getMethodName().equals("$invokeAsync")) && inv.getArguments() != null && inv.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            UnsafeByteArrayOutputStream os;
            String generic = inv.getAttachment("generic");
            if (StringUtils.isBlank((CharSequence)generic)) {
                generic = this.getGenericValueFromRpcContext();
            }
            if (appResponse.hasException()) {
                Throwable appException = appResponse.getException();
                if (appException instanceof org.apache.dubbo.rpc.service.GenericException) {
                    org.apache.dubbo.rpc.service.GenericException tmp = (org.apache.dubbo.rpc.service.GenericException)appException;
                    appException = new GenericException(tmp.getMessage(), tmp.getCause(), tmp.getExceptionClass(), tmp.getExceptionMessage());
                    appException.setStackTrace(tmp.getStackTrace());
                }
                if (!(appException instanceof GenericException)) {
                    appException = new GenericException(appException);
                }
                appResponse.setException(appException);
            }
            if (ProtocolUtils.isJavaGenericSerialization((String)generic)) {
                try {
                    os = new UnsafeByteArrayOutputStream(512);
                    ((Serialization)this.applicationModel.getExtensionLoader(Serialization.class).getExtension("nativejava")).serialize(null, (OutputStream)os).writeObject(appResponse.getValue());
                    appResponse.setValue(os.toByteArray());
                }
                catch (IOException e) {
                    throw new RpcException("Generic serialization [nativejava] serialize result failed.", (Throwable)e);
                }
            } else if (ProtocolUtils.isBeanGenericSerialization((String)generic)) {
                appResponse.setValue(JavaBeanSerializeUtil.serialize((Object)appResponse.getValue(), (JavaBeanAccessor)JavaBeanAccessor.METHOD));
            } else if (ProtocolUtils.isProtobufGenericSerialization((String)generic)) {
                try {
                    os = new UnsafeByteArrayOutputStream(512);
                    ((Serialization)this.applicationModel.getExtensionLoader(Serialization.class).getExtension("protobuf-json")).serialize(null, (OutputStream)os).writeObject(appResponse.getValue());
                    appResponse.setValue(os.toString());
                }
                catch (IOException e) {
                    throw new RpcException("Generic serialization [protobuf-json] serialize result failed.", (Throwable)e);
                }
            } else {
                if (ProtocolUtils.isGenericReturnRawResult((String)generic)) {
                    return;
                }
                appResponse.setValue(PojoUtils.generalize((Object)appResponse.getValue()));
            }
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

