/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.AccessLogData;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider"})
public class AccessLogFilter
implements Filter {
    public static ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AccessLogFilter.class);
    private static final String LOG_KEY = "dubbo.accesslog";
    private static final int LOG_MAX_BUFFER = 5000;
    private static long LOG_OUTPUT_INTERVAL = 5000L;
    private static final String FILE_DATE_FORMAT = "yyyyMMdd";
    private final DateFormat fileNameFormatter = new SimpleDateFormat("yyyyMMdd");
    private final ConcurrentMap<String, Queue<AccessLogData>> logEntries = new ConcurrentHashMap<String, Queue<AccessLogData>>();
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private ScheduledFuture<?> future;
    private static final String LINE_SEPARATOR = "line.separator";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        String accessLogKey = invoker.getUrl().getParameter("accesslog");
        boolean isFixedPath = invoker.getUrl().getParameter("accesslog.fixed.path", true);
        if (StringUtils.isEmpty((String)accessLogKey)) {
            if (this.future != null && !this.future.isCancelled()) {
                this.future.cancel(true);
                logger.info("Access log task cancelled ...");
            }
            return invoker.invoke(inv);
        }
        if (this.scheduled.compareAndSet(false, true)) {
            this.future = ((FrameworkExecutorRepository)inv.getModuleModel().getApplicationModel().getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getSharedScheduledExecutor().scheduleWithFixedDelay(new AccesslogRefreshTask(isFixedPath), LOG_OUTPUT_INTERVAL, LOG_OUTPUT_INTERVAL, TimeUnit.MILLISECONDS);
            logger.info("Access log task started ...");
        }
        Optional<Object> optionalAccessLogData = Optional.empty();
        try {
            optionalAccessLogData = Optional.of(this.buildAccessLogData(invoker, inv));
        }
        catch (Throwable t) {
            logger.warn("5-36", "", "", "Exception in AccessLogFilter of service(" + invoker + " -> " + inv + ")", t);
        }
        try {
            Result result = invoker.invoke(inv);
            return result;
        }
        finally {
            String finalAccessLogKey = accessLogKey;
            optionalAccessLogData.ifPresent(logData -> {
                logData.setOutTime(new Date());
                this.log(finalAccessLogKey, (AccessLogData)logData, isFixedPath);
            });
        }
    }

    private void log(String accessLog, AccessLogData accessLogData, boolean isFixedPath) {
        Queue logQueue = (Queue)ConcurrentHashMapUtils.computeIfAbsent(this.logEntries, (Object)accessLog, k -> new ConcurrentLinkedQueue());
        if (logQueue.size() < 5000) {
            logQueue.add(accessLogData);
        } else {
            logger.warn("5-36", "", "", "AccessLog buffer is full. Do a force writing to file to clear buffer.");
            this.writeLogSetToFile(accessLog, logQueue, isFixedPath);
            logQueue.add(accessLogData);
        }
    }

    private void writeLogSetToFile(String accessLog, Queue<AccessLogData> logSet, boolean isFixedPath) {
        try {
            if (ConfigUtils.isDefault((String)accessLog)) {
                this.processWithServiceLogger(logSet);
            } else if (isFixedPath) {
                logger.warn("0-28", "Change of accesslog file path not allowed. ", "", "Will write to the default location, \" +\n                        \"please enable this feature by setting 'accesslog.fixed.path=true' and restart the process. \" +\n                        \"We highly recommend to not enable this feature in production for security concerns, \" +\n                        \"please be fully aware of the potential risks before doing so!");
                this.processWithServiceLogger(logSet);
            } else {
                logger.warn("0-28", "Accesslog file path changed to " + accessLog + ", be aware of possible vulnerabilities!", "", "");
                File file = new File(accessLog);
                this.createIfLogDirAbsent(file);
                if (logger.isDebugEnabled()) {
                    logger.debug("Append log to " + accessLog);
                }
                this.renameFile(file);
                this.processWithAccessKeyLogger(logSet, file);
            }
        }
        catch (Exception e) {
            logger.error("5-36", "", "", e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithAccessKeyLogger(Queue<AccessLogData> logQueue, File file) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        try {
            while (!logQueue.isEmpty()) {
                writer.write(logQueue.poll().getLogMessage());
                writer.write(System.getProperty(LINE_SEPARATOR));
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private AccessLogData buildAccessLogData(Invoker<?> invoker, Invocation inv) {
        AccessLogData logData = AccessLogData.newLogData();
        logData.setServiceName(invoker.getInterface().getName());
        logData.setMethodName(RpcUtils.getMethodName(inv));
        logData.setVersion(invoker.getUrl().getVersion());
        logData.setGroup(invoker.getUrl().getGroup());
        logData.setInvocationTime(new Date());
        logData.setTypes(inv.getParameterTypes());
        logData.setArguments(inv.getArguments());
        return logData;
    }

    private void processWithServiceLogger(Queue<AccessLogData> logQueue) {
        while (!logQueue.isEmpty()) {
            AccessLogData logData = logQueue.poll();
            LoggerFactory.getLogger((String)("dubbo.accesslog." + logData.getServiceName())).info(logData.getLogMessage());
        }
    }

    private void createIfLogDirAbsent(File file) {
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
    }

    private void renameFile(File file) {
        String last;
        String now;
        if (file.exists() && !(now = this.fileNameFormatter.format(new Date())).equals(last = this.fileNameFormatter.format(new Date(file.lastModified())))) {
            File archive = new File(file.getAbsolutePath() + "." + now);
            file.renameTo(archive);
        }
    }

    public static void setInterval(long interval) {
        LOG_OUTPUT_INTERVAL = interval;
    }

    public static long getInterval() {
        return LOG_OUTPUT_INTERVAL;
    }

    public void destroy() {
        this.future.cancel(true);
    }

    class AccesslogRefreshTask
    implements Runnable {
        private final boolean isFixedPath;

        public AccesslogRefreshTask(boolean isFixedPath) {
            this.isFixedPath = isFixedPath;
        }

        @Override
        public void run() {
            if (!AccessLogFilter.this.logEntries.isEmpty()) {
                for (Map.Entry entry : AccessLogFilter.this.logEntries.entrySet()) {
                    String accessLog = (String)entry.getKey();
                    Queue logSet = (Queue)entry.getValue();
                    AccessLogFilter.this.writeLogSetToFile(accessLog, logSet, this.isFixedPath);
                }
            }
        }
    }
}

