/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.stub;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.ServiceDescriptor;

public class StubSuppliers {
    private static final Map<String, Function<Invoker<?>, Object>> STUB_SUPPLIERS = new ConcurrentHashMap();
    private static final Map<String, ServiceDescriptor> SERVICE_DESCRIPTOR_MAP = new ConcurrentHashMap<String, ServiceDescriptor>();

    public static void addDescriptor(String interfaceName, ServiceDescriptor serviceDescriptor) {
        SERVICE_DESCRIPTOR_MAP.put(interfaceName, serviceDescriptor);
    }

    public static void addSupplier(String interfaceName, Function<Invoker<?>, Object> supplier) {
        STUB_SUPPLIERS.put(interfaceName, supplier);
    }

    public static <T> T createStub(String interfaceName, Invoker<T> invoker) {
        if (!STUB_SUPPLIERS.containsKey(interfaceName)) {
            ReflectUtils.forName((String)StubSuppliers.stubClassName(interfaceName));
            if (!STUB_SUPPLIERS.containsKey(interfaceName)) {
                throw new IllegalStateException("Can not find any stub supplier for " + interfaceName);
            }
        }
        return (T)STUB_SUPPLIERS.get(interfaceName).apply(invoker);
    }

    private static String stubClassName(String interfaceName) {
        int idx = interfaceName.lastIndexOf(46);
        String pkg = interfaceName.substring(0, idx + 1);
        String name = interfaceName.substring(idx + 1);
        return pkg + "Dubbo" + name + "Triple";
    }

    public static ServiceDescriptor getServiceDescriptor(String interfaceName) {
        if (!SERVICE_DESCRIPTOR_MAP.containsKey(interfaceName)) {
            ReflectUtils.forName((String)StubSuppliers.stubClassName(interfaceName));
            if (!SERVICE_DESCRIPTOR_MAP.containsKey(interfaceName)) {
                throw new IllegalStateException("Can not find any stub supplier for " + interfaceName);
            }
        }
        return SERVICE_DESCRIPTOR_MAP.get(interfaceName);
    }
}

