/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;
import org.apache.dubbo.rpc.model.ConsumerModel;

@Activate(group={"consumer"})
public class FutureFilter
implements Filter {
    protected static final Logger logger = LoggerFactory.getLogger(FutureFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        this.fireInvokeCallback(invoker, invocation);
        return invoker.invoke(invocation);
    }

    public Result onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (result instanceof AsyncRpcResult) {
            AsyncRpcResult asyncResult = (AsyncRpcResult)result;
            asyncResult.thenApplyWithContext(r -> {
                this.asyncCallback(invoker, invocation, (Result)r);
                return r;
            });
            return asyncResult;
        }
        this.syncCallback(invoker, invocation, result);
        return result;
    }

    private void syncCallback(Invoker<?> invoker, Invocation invocation, Result result) {
        if (result.hasException()) {
            this.fireThrowCallback(invoker, invocation, result.getException());
        } else {
            this.fireReturnCallback(invoker, invocation, result.getValue());
        }
    }

    private void asyncCallback(Invoker<?> invoker, Invocation invocation, Result result) {
        if (result.hasException()) {
            this.fireThrowCallback(invoker, invocation, result.getException());
        } else {
            this.fireReturnCallback(invoker, invocation, result.getValue());
        }
    }

    private void fireInvokeCallback(Invoker<?> invoker, Invocation invocation) {
        ConsumerMethodModel.AsyncMethodInfo asyncMethodInfo = this.getAsyncMethodInfo(invoker, invocation);
        if (asyncMethodInfo == null) {
            return;
        }
        Method onInvokeMethod = asyncMethodInfo.getOninvokeMethod();
        Object onInvokeInst = asyncMethodInfo.getOninvokeInstance();
        if (onInvokeMethod == null && onInvokeInst == null) {
            return;
        }
        if (onInvokeMethod == null || onInvokeInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a oninvoke callback config , but no such " + (onInvokeMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (!onInvokeMethod.isAccessible()) {
            onInvokeMethod.setAccessible(true);
        }
        Object[] params = invocation.getArguments();
        try {
            onInvokeMethod.invoke(onInvokeInst, params);
        }
        catch (InvocationTargetException e) {
            this.fireThrowCallback(invoker, invocation, e.getTargetException());
        }
        catch (Throwable e) {
            this.fireThrowCallback(invoker, invocation, e);
        }
    }

    private void fireReturnCallback(Invoker<?> invoker, Invocation invocation, Object result) {
        Object[] params;
        ConsumerMethodModel.AsyncMethodInfo asyncMethodInfo = this.getAsyncMethodInfo(invoker, invocation);
        if (asyncMethodInfo == null) {
            return;
        }
        Method onReturnMethod = asyncMethodInfo.getOnreturnMethod();
        Object onReturnInst = asyncMethodInfo.getOnreturnInstance();
        if (onReturnMethod == null && onReturnInst == null) {
            return;
        }
        if (onReturnMethod == null || onReturnInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onreturn callback config , but no such " + (onReturnMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (!onReturnMethod.isAccessible()) {
            onReturnMethod.setAccessible(true);
        }
        Object[] args = invocation.getArguments();
        Class<?>[] rParaTypes = onReturnMethod.getParameterTypes();
        if (rParaTypes.length > 1) {
            if (rParaTypes.length == 2 && rParaTypes[1].isAssignableFrom(Object[].class)) {
                params = new Object[]{result, args};
            } else {
                params = new Object[args.length + 1];
                params[0] = result;
                System.arraycopy(args, 0, params, 1, args.length);
            }
        } else {
            params = new Object[]{result};
        }
        try {
            onReturnMethod.invoke(onReturnInst, params);
        }
        catch (InvocationTargetException e) {
            this.fireThrowCallback(invoker, invocation, e.getTargetException());
        }
        catch (Throwable e) {
            this.fireThrowCallback(invoker, invocation, e);
        }
    }

    private void fireThrowCallback(Invoker<?> invoker, Invocation invocation, Throwable exception) {
        Class<?>[] rParaTypes;
        ConsumerMethodModel.AsyncMethodInfo asyncMethodInfo = this.getAsyncMethodInfo(invoker, invocation);
        if (asyncMethodInfo == null) {
            return;
        }
        Method onthrowMethod = asyncMethodInfo.getOnthrowMethod();
        Object onthrowInst = asyncMethodInfo.getOnthrowInstance();
        if (onthrowMethod == null && onthrowInst == null) {
            return;
        }
        if (onthrowMethod == null || onthrowInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onthrow callback config , but no such " + (onthrowMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (!onthrowMethod.isAccessible()) {
            onthrowMethod.setAccessible(true);
        }
        if ((rParaTypes = onthrowMethod.getParameterTypes())[0].isAssignableFrom(exception.getClass())) {
            try {
                Object[] params;
                Object[] args = invocation.getArguments();
                if (rParaTypes.length > 1) {
                    if (rParaTypes.length == 2 && rParaTypes[1].isAssignableFrom(Object[].class)) {
                        params = new Object[]{exception, args};
                    } else {
                        params = new Object[args.length + 1];
                        params[0] = exception;
                        System.arraycopy(args, 0, params, 1, args.length);
                    }
                } else {
                    params = new Object[]{exception};
                }
                onthrowMethod.invoke(onthrowInst, params);
            }
            catch (Throwable e) {
                logger.error(invocation.getMethodName() + ".call back method invoke error . callback method :" + onthrowMethod + ", url:" + invoker.getUrl(), e);
            }
        } else {
            logger.error(invocation.getMethodName() + ".call back method invoke error . callback method :" + onthrowMethod + ", url:" + invoker.getUrl(), exception);
        }
    }

    private ConsumerMethodModel.AsyncMethodInfo getAsyncMethodInfo(Invoker<?> invoker, Invocation invocation) {
        ConsumerMethodModel methodModel;
        ConsumerModel consumerModel = ApplicationModel.getConsumerModel((String)invoker.getUrl().getServiceKey());
        if (consumerModel == null) {
            return null;
        }
        String methodName = invocation.getMethodName();
        if (methodName.equals("$invoke")) {
            methodName = (String)invocation.getArguments()[0];
        }
        if ((methodModel = consumerModel.getMethodModel(methodName)) == null) {
            return null;
        }
        ConsumerMethodModel.AsyncMethodInfo asyncMethodInfo = methodModel.getAsyncInfo();
        if (asyncMethodInfo == null) {
            return null;
        }
        return asyncMethodInfo;
    }
}

