/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.rpc.ProtocolServer;

public class DubboProtocolServer
implements ProtocolServer {
    private RemotingServer server;
    private String address;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public DubboProtocolServer(RemotingServer server) {
        this.server = server;
    }

    public RemotingServer getRemotingServer() {
        return this.server;
    }

    public String getAddress() {
        return StringUtils.isNotEmpty((String)this.address) ? this.address : this.server.getUrl().getAddress();
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public URL getUrl() {
        return this.server.getUrl();
    }

    public void reset(URL url) {
        this.server.reset(url);
    }

    public void close() {
        this.server.close();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

