/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.util.Map;
import org.apache.dubbo.common.ServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.executor.AbstractIsolationExecutorSupport;

public class DubboIsolationExecutorSupport
extends AbstractIsolationExecutorSupport {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboIsolationExecutorSupport.class);

    public DubboIsolationExecutorSupport(URL url) {
        super(url);
    }

    protected ServiceKey getServiceKey(Object data) {
        if (!(data instanceof Request)) {
            return null;
        }
        try {
            Request request = (Request)data;
            if (request.getData() == null || !(request.getData() instanceof Invocation)) {
                return null;
            }
            Invocation inv = (Invocation)request.getData();
            Map attachments = inv.getAttachments();
            String interfaceName = (String)attachments.get("path");
            String version = (String)attachments.get("version");
            String group = (String)attachments.get("group");
            return new ServiceKey(interfaceName, version, group);
        }
        catch (Throwable e) {
            logger.error("failed to get service key, maybe the build rule for data is wrong, data = " + data, e);
            return null;
        }
    }
}

