/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.Transporter;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.ExchangeServer;
import org.apache.dubbo.remoting.exchange.Exchangers;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.remoting.exchange.support.ExchangeHandlerAdapter;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.dubbo.DubboExporter;
import org.apache.dubbo.rpc.protocol.dubbo.DubboInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocolServer;
import org.apache.dubbo.rpc.protocol.dubbo.LazyConnectExchangeClient;
import org.apache.dubbo.rpc.protocol.dubbo.ReferenceCountExchangeClient;

public class DubboProtocol
extends AbstractProtocol {
    public static final String NAME = "dubbo";
    public static final int DEFAULT_PORT = 20880;
    private static final String IS_CALLBACK_SERVICE_INVOKE = "_isCallBackServiceInvoke";
    private final Map<String, Object> referenceClientMap = new ConcurrentHashMap<String, Object>();
    private static final Object PENDING_OBJECT = new Object();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final ExchangeHandler requestHandler;

    public DubboProtocol(FrameworkModel frameworkModel) {
        this.requestHandler = new ExchangeHandlerAdapter(frameworkModel){

            public CompletableFuture<Object> reply(ExchangeChannel channel, Object message) throws RemotingException {
                if (!(message instanceof Invocation)) {
                    throw new RemotingException((Channel)channel, "Unsupported request: " + (message == null ? null : message.getClass().getName() + ": " + message) + ", channel: consumer: " + channel.getRemoteAddress() + " --> provider: " + channel.getLocalAddress());
                }
                Invocation inv = (Invocation)message;
                Invoker<?> invoker = DubboProtocol.this.getInvoker((Channel)channel, inv);
                inv.setServiceModel(invoker.getUrl().getServiceModel());
                if (invoker.getUrl().getServiceModel() != null) {
                    Thread.currentThread().setContextClassLoader(invoker.getUrl().getServiceModel().getClassLoader());
                }
                if (Boolean.TRUE.toString().equals(inv.getObjectAttachmentWithoutConvert(DubboProtocol.IS_CALLBACK_SERVICE_INVOKE))) {
                    String methodsStr = (String)invoker.getUrl().getParameters().get("methods");
                    boolean hasMethod = false;
                    if (methodsStr == null || !methodsStr.contains(",")) {
                        hasMethod = inv.getMethodName().equals(methodsStr);
                    } else {
                        String[] methods;
                        for (String method : methods = methodsStr.split(",")) {
                            if (!inv.getMethodName().equals(method)) continue;
                            hasMethod = true;
                            break;
                        }
                    }
                    if (!hasMethod) {
                        DubboProtocol.this.logger.warn("4-3", "", "", new IllegalStateException("The methodName " + inv.getMethodName() + " not found in callback service interface ,invoke will be ignored. please update the api interface. url is:" + invoker.getUrl()) + " ,invocation is :" + inv);
                        return null;
                    }
                }
                RpcContext.getServiceContext().setRemoteAddress(channel.getRemoteAddress());
                Result result = invoker.invoke(inv);
                return result.thenApply(Function.identity());
            }

            public void received(Channel channel, Object message) throws RemotingException {
                if (message instanceof Invocation) {
                    this.reply((ExchangeChannel)channel, message);
                } else {
                    super.received(channel, message);
                }
            }

            public void connected(Channel channel) throws RemotingException {
                this.invoke(channel, "onconnect");
            }

            public void disconnected(Channel channel) throws RemotingException {
                if (DubboProtocol.this.logger.isDebugEnabled()) {
                    DubboProtocol.this.logger.debug("disconnected from " + channel.getRemoteAddress() + ",url:" + channel.getUrl());
                }
                this.invoke(channel, "ondisconnect");
            }

            private void invoke(Channel channel, String methodKey) {
                Invocation invocation = this.createInvocation(channel, channel.getUrl(), methodKey);
                if (invocation != null) {
                    try {
                        if (Boolean.TRUE.toString().equals(invocation.getAttachment("dubbo.stub.event"))) {
                            this.tryToGetStubService(channel, invocation);
                        }
                        this.received(channel, invocation);
                    }
                    catch (Throwable t) {
                        DubboProtocol.this.logger.warn("4-3", "", "", "Failed to invoke event method " + invocation.getMethodName() + "(), cause: " + t.getMessage(), t);
                    }
                }
            }

            private void tryToGetStubService(Channel channel, Invocation invocation) throws RemotingException {
                try {
                    Invoker<?> invoker = DubboProtocol.this.getInvoker(channel, invocation);
                }
                catch (RemotingException e) {
                    String serviceKey = DubboProtocol.serviceKey((int)0, (String)((String)invocation.getObjectAttachmentWithoutConvert("path")), (String)((String)invocation.getObjectAttachmentWithoutConvert("version")), (String)((String)invocation.getObjectAttachmentWithoutConvert("group")));
                    throw new RemotingException(channel, "The stub service[" + serviceKey + "] is not found, it may not be exported yet");
                }
            }

            private Invocation createInvocation(Channel channel, URL url, String methodKey) {
                String method = url.getParameter(methodKey);
                if (method == null || method.length() == 0) {
                    return null;
                }
                RpcInvocation invocation = new RpcInvocation(url.getServiceModel(), method, url.getParameter("interface"), "", new Class[0], new Object[0]);
                invocation.setAttachment("path", url.getPath());
                invocation.setAttachment("group", url.getGroup());
                invocation.setAttachment("interface", url.getParameter("interface"));
                invocation.setAttachment("version", url.getVersion());
                if (url.getParameter("dubbo.stub.event", false)) {
                    invocation.setAttachment("dubbo.stub.event", Boolean.TRUE.toString());
                }
                return invocation;
            }
        };
    }

    @Deprecated
    public static DubboProtocol getDubboProtocol() {
        return (DubboProtocol)((Object)FrameworkModel.defaultModel().getExtensionLoader(Protocol.class).getExtension(NAME, false));
    }

    public static DubboProtocol getDubboProtocol(ScopeModel scopeModel) {
        return (DubboProtocol)((Object)scopeModel.getExtensionLoader(Protocol.class).getExtension(NAME, false));
    }

    private boolean isClientSide(Channel channel) {
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        return url.getPort() == address.getPort() && NetUtils.filterLocalHost((String)channel.getUrl().getIp()).equals(NetUtils.filterLocalHost((String)address.getAddress().getHostAddress()));
    }

    Invoker<?> getInvoker(Channel channel, Invocation inv) throws RemotingException {
        String serviceKey;
        DubboExporter exporter;
        boolean isCallBackServiceInvoke;
        int port = channel.getLocalAddress().getPort();
        String path = (String)inv.getObjectAttachmentWithoutConvert("path");
        boolean isStubServiceInvoke = Boolean.TRUE.toString().equals(inv.getObjectAttachmentWithoutConvert("dubbo.stub.event"));
        if (isStubServiceInvoke) {
            port = 0;
        }
        boolean bl = isCallBackServiceInvoke = this.isClientSide(channel) && !isStubServiceInvoke;
        if (isCallBackServiceInvoke) {
            path = path + "." + inv.getObjectAttachmentWithoutConvert("callback.service.instid");
            inv.setObjectAttachment(IS_CALLBACK_SERVICE_INVOKE, (Object)Boolean.TRUE.toString());
        }
        if ((exporter = (DubboExporter)((Object)this.exporterMap.get(serviceKey = DubboProtocol.serviceKey((int)port, (String)path, (String)((String)inv.getObjectAttachmentWithoutConvert("version")), (String)((String)inv.getObjectAttachmentWithoutConvert("group")))))) == null) {
            throw new RemotingException(channel, "Not found exported service: " + serviceKey + " in " + this.exporterMap.keySet() + ", may be version or group mismatch , channel: consumer: " + channel.getRemoteAddress() + " --> provider: " + channel.getLocalAddress() + ", message:" + this.getInvocationWithoutData(inv));
        }
        return exporter.getInvoker();
    }

    public Collection<Invoker<?>> getInvokers() {
        return Collections.unmodifiableCollection(this.invokers);
    }

    public int getDefaultPort() {
        return 20880;
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        String stubServiceMethods;
        this.checkDestroyed();
        URL url = invoker.getUrl();
        String key = DubboProtocol.serviceKey((URL)url);
        DubboExporter<T> exporter = new DubboExporter<T>(invoker, key, this.exporterMap);
        boolean isStubSupportEvent = url.getParameter("dubbo.stub.event", false);
        boolean isCallbackService = url.getParameter("is_callback_service", false);
        if (isStubSupportEvent && !isCallbackService && ((stubServiceMethods = url.getParameter("dubbo.stub.event.methods")) == null || stubServiceMethods.length() == 0) && this.logger.isWarnEnabled()) {
            this.logger.warn("4-1", "", "", "consumer [" + url.getParameter("interface") + "], has set stub proxy support event ,but no stub methods founded.");
        }
        this.openServer(url);
        this.optimizeSerialization(url);
        return exporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openServer(URL url) {
        this.checkDestroyed();
        String key = url.getAddress();
        boolean isServer = url.getParameter("isserver", true);
        if (isServer) {
            ProtocolServer server = (ProtocolServer)this.serverMap.get(key);
            if (server == null) {
                DubboProtocol dubboProtocol = this;
                synchronized (dubboProtocol) {
                    server = (ProtocolServer)this.serverMap.get(key);
                    if (server == null) {
                        this.serverMap.put(key, this.createServer(url));
                        return;
                    }
                }
            }
            server.reset(url);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed.get()) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " is destroyed");
        }
    }

    private ProtocolServer createServer(URL url) {
        ExchangeServer server;
        String transporter = (url = URLBuilder.from((URL)url).addParameterIfAbsent("channel.readonly.sent", Boolean.TRUE.toString()).addParameterIfAbsent("heartbeat", String.valueOf(60000)).addParameter("codec", NAME).build()).getParameter("server", "netty");
        if (StringUtils.isNotEmpty((String)transporter) && !url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).hasExtension(transporter)) {
            throw new RpcException("Unsupported server type: " + transporter + ", url: " + url);
        }
        try {
            server = Exchangers.bind((URL)url, (ExchangeHandler)this.requestHandler);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to start server(url: " + url + ") " + e.getMessage(), (Throwable)e);
        }
        transporter = url.getParameter("client");
        if (StringUtils.isNotEmpty((String)transporter) && !url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).hasExtension(transporter)) {
            throw new RpcException("Unsupported client type: " + transporter);
        }
        DubboProtocolServer protocolServer = new DubboProtocolServer((RemotingServer)server);
        this.loadServerProperties(protocolServer);
        return protocolServer;
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.checkDestroyed();
        return this.protocolBindingRefer(type, url);
    }

    public <T> Invoker<T> protocolBindingRefer(Class<T> serviceType, URL url) throws RpcException {
        this.checkDestroyed();
        this.optimizeSerialization(url);
        DubboInvoker<T> invoker = new DubboInvoker<T>(serviceType, url, this.getClients(url), this.invokers);
        this.invokers.add(invoker);
        return invoker;
    }

    private ExchangeClient[] getClients(URL url) {
        int connections = url.getParameter("connections", 0);
        if (connections == 0) {
            String shareConnectionsStr = StringUtils.isBlank((CharSequence)url.getParameter("shareconnections", (String)null)) ? ConfigurationUtils.getProperty((ScopeModel)url.getOrDefaultApplicationModel(), (String)"shareconnections", (String)"1") : url.getParameter("shareconnections", (String)null);
            connections = Integer.parseInt(shareConnectionsStr);
            List<ReferenceCountExchangeClient> shareClients = this.getSharedClient(url, connections);
            ExchangeClient[] clients = new ExchangeClient[connections];
            Arrays.setAll(clients, shareClients::get);
            return clients;
        }
        ExchangeClient[] clients = new ExchangeClient[connections];
        for (int i = 0; i < clients.length; ++i) {
            clients[i] = this.initClient(url);
        }
        return clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceCountExchangeClient> getSharedClient(URL url, int connectNum) {
        List typedClients;
        String key = url.getAddress();
        Object clients = this.referenceClientMap.get(key);
        if (clients instanceof List && this.checkClientCanUse(typedClients = (List)clients)) {
            this.batchClientRefIncr(typedClients);
            return typedClients;
        }
        typedClients = null;
        Map<String, Object> map = this.referenceClientMap;
        synchronized (map) {
            block24: {
                while (true) {
                    if ((clients = this.referenceClientMap.get(key)) instanceof List) {
                        typedClients = (List)clients;
                        if (this.checkClientCanUse(typedClients)) {
                            this.batchClientRefIncr(typedClients);
                            return typedClients;
                        }
                        this.referenceClientMap.put(key, PENDING_OBJECT);
                        break block24;
                    }
                    if (clients != PENDING_OBJECT) break;
                    try {
                        this.referenceClientMap.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.referenceClientMap.put(key, PENDING_OBJECT);
            }
        }
        try {
            connectNum = Math.max(connectNum, 1);
            if (CollectionUtils.isEmpty((Collection)typedClients)) {
                typedClients = this.buildReferenceCountExchangeClientList(url, connectNum);
            } else {
                for (int i = 0; i < typedClients.size(); ++i) {
                    ReferenceCountExchangeClient referenceCountExchangeClient = typedClients.get(i);
                    if (referenceCountExchangeClient == null || referenceCountExchangeClient.isClosed()) {
                        typedClients.set(i, (ReferenceCountExchangeClient)this.buildReferenceCountExchangeClient(url));
                        continue;
                    }
                    referenceCountExchangeClient.incrementAndGetCount();
                }
            }
        }
        finally {
            Map<String, Object> map2 = this.referenceClientMap;
            synchronized (map2) {
                if (typedClients == null) {
                    this.referenceClientMap.remove(key);
                } else {
                    this.referenceClientMap.put(key, typedClients);
                }
                this.referenceClientMap.notifyAll();
            }
        }
        return typedClients;
    }

    private boolean checkClientCanUse(List<ReferenceCountExchangeClient> referenceCountExchangeClients) {
        if (CollectionUtils.isEmpty(referenceCountExchangeClients)) {
            return false;
        }
        return referenceCountExchangeClients.stream().noneMatch(referenceCountExchangeClient -> referenceCountExchangeClient == null || referenceCountExchangeClient.getCount() <= 0 || referenceCountExchangeClient.isClosed());
    }

    private void batchClientRefIncr(List<ReferenceCountExchangeClient> referenceCountExchangeClients) {
        if (CollectionUtils.isEmpty(referenceCountExchangeClients)) {
            return;
        }
        referenceCountExchangeClients.stream().filter(Objects::nonNull).forEach(ReferenceCountExchangeClient::incrementAndGetCount);
    }

    private List<ReferenceCountExchangeClient> buildReferenceCountExchangeClientList(URL url, int connectNum) {
        ArrayList<ReferenceCountExchangeClient> clients = new ArrayList<ReferenceCountExchangeClient>();
        for (int i = 0; i < connectNum; ++i) {
            clients.add(this.buildReferenceCountExchangeClient(url));
        }
        return clients;
    }

    private ReferenceCountExchangeClient buildReferenceCountExchangeClient(URL url) {
        ExchangeClient exchangeClient = this.initClient(url);
        ReferenceCountExchangeClient client = new ReferenceCountExchangeClient(exchangeClient, NAME);
        int shutdownTimeout = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)url.getScopeModel());
        client.setShutdownWaitTime(shutdownTimeout);
        return client;
    }

    private ExchangeClient initClient(URL url) {
        String str = url.getParameter("client", url.getParameter("server", "netty"));
        if (StringUtils.isNotEmpty((String)str) && !url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).hasExtension(str)) {
            throw new RpcException("Unsupported client type: " + str + ", supported client type is " + StringUtils.join((Collection)url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).getSupportedExtensions(), (String)" "));
        }
        try {
            url = new ServiceConfigURL(NAME, url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath(), url.getAllParameters());
            url = url.addParameter("codec", NAME);
            url = url.addParameterIfAbsent("heartbeat", String.valueOf(60000));
            return url.getParameter("lazy", false) ? new LazyConnectExchangeClient(url, this.requestHandler) : Exchangers.connect((URL)url, (ExchangeHandler)this.requestHandler);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to create remoting client for service(" + url + "): " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying protocol [" + ((Object)((Object)this)).getClass().getSimpleName() + "] ...");
        }
        for (String key : new ArrayList(this.serverMap.keySet())) {
            ProtocolServer protocolServer = (ProtocolServer)this.serverMap.remove(key);
            if (protocolServer == null) continue;
            RemotingServer server = protocolServer.getRemotingServer();
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Closing dubbo server: " + server.getLocalAddress());
                }
                server.close(this.getServerShutdownTimeout(protocolServer));
            }
            catch (Throwable t) {
                this.logger.warn("4-8", "", "", "Close dubbo server [" + server.getLocalAddress() + "] failed: " + t.getMessage(), t);
            }
        }
        this.serverMap.clear();
        for (String key : new ArrayList<String>(this.referenceClientMap.keySet())) {
            List typedClients;
            Object clients = this.referenceClientMap.remove(key);
            if (!(clients instanceof List) || CollectionUtils.isEmpty((Collection)(typedClients = (List)clients))) continue;
            for (ReferenceCountExchangeClient client : typedClients) {
                this.closeReferenceCountExchangeClient(client);
            }
        }
        PortUnificationExchanger.close();
        this.referenceClientMap.clear();
        super.destroy();
    }

    private void closeReferenceCountExchangeClient(ReferenceCountExchangeClient client) {
        if (client == null) {
            return;
        }
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Close dubbo connect: " + client.getLocalAddress() + "-->" + client.getRemoteAddress());
            }
            client.close(client.getShutdownWaitTime());
        }
        catch (Throwable t) {
            this.logger.warn("4-7", "", "", t.getMessage(), t);
        }
    }

    private Invocation getInvocationWithoutData(Invocation invocation) {
        if (this.logger.isDebugEnabled()) {
            return invocation;
        }
        if (invocation instanceof RpcInvocation) {
            RpcInvocation rpcInvocation = (RpcInvocation)invocation;
            rpcInvocation.setArguments(null);
            return rpcInvocation;
        }
        return invocation;
    }
}

