/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.util.List;
import java.util.Objects;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.protocol.dubbo.ClientsProvider;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;
import org.apache.dubbo.rpc.protocol.dubbo.ReferenceCountExchangeClient;

public class SharedClientsProvider
implements ClientsProvider {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SharedClientsProvider.class);
    private final DubboProtocol dubboProtocol;
    private final String addressKey;
    private final List<ReferenceCountExchangeClient> clients;

    public SharedClientsProvider(DubboProtocol dubboProtocol, String addressKey, List<ReferenceCountExchangeClient> clients) {
        this.dubboProtocol = dubboProtocol;
        this.addressKey = addressKey;
        this.clients = clients;
    }

    public List<ReferenceCountExchangeClient> getClients() {
        return this.clients;
    }

    public synchronized boolean increaseCount() {
        if (this.checkClientCanUse(this.clients)) {
            this.batchClientRefIncr(this.clients);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close(int timeout) {
        for (ReferenceCountExchangeClient client : this.clients) {
            try {
                client.close(timeout);
            }
            catch (Throwable t) {
                logger.warn("4-7", "", "", t.getMessage(), t);
            }
        }
        if (!this.checkClientCanUse(this.clients)) {
            this.dubboProtocol.scheduleRemoveSharedClient(this.addressKey, this);
        }
    }

    public synchronized void forceClose() {
        for (ReferenceCountExchangeClient client : this.clients) {
            this.closeReferenceCountExchangeClient(client);
        }
    }

    private boolean checkClientCanUse(List<ReferenceCountExchangeClient> referenceCountExchangeClients) {
        if (CollectionUtils.isEmpty(referenceCountExchangeClients)) {
            return false;
        }
        return referenceCountExchangeClients.stream().noneMatch(referenceCountExchangeClient -> referenceCountExchangeClient == null || referenceCountExchangeClient.getCount() <= 0 || referenceCountExchangeClient.isClosed());
    }

    private void batchClientRefIncr(List<ReferenceCountExchangeClient> referenceCountExchangeClients) {
        if (CollectionUtils.isEmpty(referenceCountExchangeClients)) {
            return;
        }
        referenceCountExchangeClients.stream().filter(Objects::nonNull).forEach(ReferenceCountExchangeClient::incrementAndGetCount);
    }

    private void closeReferenceCountExchangeClient(ReferenceCountExchangeClient client) {
        if (client == null) {
            return;
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Close dubbo connect: " + client.getLocalAddress() + "-->" + client.getRemoteAddress());
            }
            client.close(ConfigurationUtils.reCalShutdownTime((int)client.getShutdownWaitTime()));
        }
        catch (Throwable t) {
            logger.warn("4-7", "", "", t.getMessage(), t);
        }
    }
}

