/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ClientInterceptor;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ServerInterceptor;

@Activate(group={"provider", "consumer"})
public class RpcContextInterceptor
implements ClientInterceptor,
ServerInterceptor {
    private static final String DUBBO = "D-";

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        RpcContext rpcContext = RpcContext.getContext();
        Map attachments = rpcContext.getObjectAttachments();
        if (attachments != null) {
            for (Map.Entry entry : attachments.entrySet()) {
                callOptions = callOptions.withOption(CallOptions.Key.create((String)(DUBBO + (String)entry.getKey())), entry.getValue());
            }
        }
        return next.newCall(method, callOptions);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        RpcContext rpcContext = RpcContext.getContext();
        Set keys = headers.keys();
        if (keys != null) {
            keys.stream().filter(k -> k.startsWith(DUBBO)).forEach(k -> rpcContext.setAttachment(k.substring(DUBBO.length()), (String)headers.get(Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))));
        }
        return next.startCall(call, headers);
    }
}

