/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.hessian;

import com.caucho.hessian.HessianException;
import com.caucho.hessian.client.HessianConnectionException;
import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.io.HessianMethodSerializationException;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.hessian.DubboHessianURLConnectionFactory;
import org.apache.dubbo.rpc.protocol.hessian.HttpClientConnectionFactory;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class HessianProtocol
extends AbstractProxyProtocol {
    private final Map<String, HessianSkeleton> skeletonMap = new ConcurrentHashMap<String, HessianSkeleton>();
    private HttpBinder httpBinder;

    public HessianProtocol() {
        super(new Class[]{HessianException.class});
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    public int getDefaultPort() {
        return 80;
    }

    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        String addr = this.getAddr(url);
        ProtocolServer protocolServer = (ProtocolServer)this.serverMap.get(addr);
        if (protocolServer == null) {
            HttpServer remotingServer = this.httpBinder.bind(url, (HttpHandler)new HessianHandler());
            this.serverMap.put(addr, new AbstractProxyProtocol.ProxyProtocolServer((AbstractProxyProtocol)this, (RemotingServer)remotingServer));
        }
        final String path = url.getAbsolutePath();
        HessianSkeleton skeleton = new HessianSkeleton(impl, type);
        this.skeletonMap.put(path, skeleton);
        final String genericPath = path + "/" + "generic";
        this.skeletonMap.put(genericPath, new HessianSkeleton(impl, GenericService.class));
        return new Runnable(){

            @Override
            public void run() {
                HessianProtocol.this.skeletonMap.remove(path);
                HessianProtocol.this.skeletonMap.remove(genericPath);
            }
        };
    }

    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        Object factory;
        boolean isGeneric;
        String generic = url.getParameter("generic");
        boolean bl = isGeneric = ProtocolUtils.isGeneric((String)generic) || serviceType.equals(GenericService.class);
        if (isGeneric) {
            RpcContext.getContext().setAttachment("generic", generic);
            url = url.setPath(url.getPath() + "/" + "generic");
        }
        HessianProxyFactory hessianProxyFactory = new HessianProxyFactory();
        boolean isHessian2Request = url.getParameter("hessian2.request", false);
        hessianProxyFactory.setHessian2Request(isHessian2Request);
        boolean isOverloadEnabled = url.getParameter("hessian.overload.method", false);
        hessianProxyFactory.setOverloadEnabled(isOverloadEnabled);
        String client = url.getParameter("client", "jdk");
        if ("httpclient".equals(client)) {
            factory = new HttpClientConnectionFactory();
            factory.setHessianProxyFactory(hessianProxyFactory);
            hessianProxyFactory.setConnectionFactory((HessianConnectionFactory)factory);
        } else {
            if (client != null && client.length() > 0 && !"jdk".equals(client)) {
                throw new IllegalStateException("Unsupported http protocol client=\"" + client + "\"!");
            }
            factory = new DubboHessianURLConnectionFactory();
            factory.setHessianProxyFactory(hessianProxyFactory);
            hessianProxyFactory.setConnectionFactory((HessianConnectionFactory)factory);
        }
        int timeout = url.getParameter("timeout", 1000);
        hessianProxyFactory.setConnectTimeout((long)timeout);
        hessianProxyFactory.setReadTimeout((long)timeout);
        return (T)hessianProxyFactory.create(serviceType, url.setProtocol("http").toJavaURL(), Thread.currentThread().getContextClassLoader());
    }

    protected int getErrorCode(Throwable e) {
        if (e instanceof HessianConnectionException) {
            Class<?> cls;
            if (e.getCause() != null && SocketTimeoutException.class.equals(cls = e.getCause().getClass())) {
                return 2;
            }
            return 1;
        }
        if (e instanceof HessianMethodSerializationException) {
            return 5;
        }
        return super.getErrorCode(e);
    }

    public void destroy() {
        super.destroy();
        for (String key : new ArrayList(this.serverMap.keySet())) {
            ProtocolServer protocolServer = (ProtocolServer)this.serverMap.remove(key);
            if (protocolServer == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Close hessian server " + protocolServer.getUrl());
                }
                protocolServer.close();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    private class HessianHandler
    implements HttpHandler {
        private HessianHandler() {
        }

        public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = request.getRequestURI();
            HessianSkeleton skeleton = (HessianSkeleton)HessianProtocol.this.skeletonMap.get(uri);
            if (!"POST".equalsIgnoreCase(request.getMethod())) {
                response.setStatus(500);
            } else {
                RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
                Enumeration enumeration = request.getHeaderNames();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    if (!key.startsWith("header")) continue;
                    RpcContext.getContext().setAttachment(key.substring("header".length()), request.getHeader(key));
                }
                try {
                    skeleton.invoke((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
            }
        }
    }
}

