/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.injvm;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.injvm.InjvmExporter;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;

class InjvmInvoker<T>
extends AbstractInvoker<T> {
    private final String key;
    private final Map<String, Exporter<?>> exporterMap;
    private final ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();

    InjvmInvoker(Class<T> type, URL url, String key, Map<String, Exporter<?>> exporterMap) {
        super(type, url);
        this.key = key;
        this.exporterMap = exporterMap;
    }

    public boolean isAvailable() {
        InjvmExporter exporter = (InjvmExporter)this.exporterMap.get(this.key);
        if (exporter == null) {
            return false;
        }
        return super.isAvailable();
    }

    public Result doInvoke(Invocation invocation) throws Throwable {
        Exporter<?> exporter = InjvmProtocol.getExporter(this.exporterMap, this.getUrl());
        if (exporter == null) {
            throw new RpcException("Service [" + this.key + "] not found.");
        }
        RpcContext.getServiceContext().setRemoteAddress("127.0.0.1", 0);
        URL serverURL = exporter.getInvoker().getUrl();
        boolean serverHasToken = serverURL.hasParameter("token");
        if (serverHasToken) {
            invocation.setAttachment("token", serverURL.getParameter("token"));
        }
        if (this.isAsync(exporter.getInvoker().getUrl(), this.getUrl())) {
            ((RpcInvocation)invocation).setInvokeMode(InvokeMode.ASYNC);
            ExecutorService executor = this.executorRepository.createExecutorIfAbsent(this.getUrl());
            CompletableFuture<AppResponse> appResponseFuture = CompletableFuture.supplyAsync(() -> {
                Result result = exporter.getInvoker().invoke(invocation);
                if (result.hasException()) {
                    return new AppResponse(result.getException());
                }
                return new AppResponse(result.getValue());
            }, executor);
            FutureContext.getContext().setCompatibleFuture(appResponseFuture);
            AsyncRpcResult result = new AsyncRpcResult(appResponseFuture, invocation);
            result.setExecutor((Executor)executor);
            return result;
        }
        return exporter.getInvoker().invoke(invocation);
    }

    private boolean isAsync(URL remoteUrl, URL localUrl) {
        if (localUrl.hasParameter("async")) {
            return localUrl.getParameter("async", false);
        }
        return remoteUrl.getParameter("async", false);
    }
}

