/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import io.netty.channel.ChannelOption;
import java.util.HashMap;
import org.apache.dubbo.common.Constants;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.protocol.rest.BaseRestServer;
import org.jboss.resteasy.plugins.server.netty.NettyJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class NettyServer
extends BaseRestServer {
    private final NettyJaxrsServer server = new NettyJaxrsServer();

    @Override
    protected void doStart(URL url) {
        String bindIp = url.getParameter("bind.ip", url.getHost());
        if (!url.isAnyHost() && NetUtils.isValidLocalHost((String)bindIp)) {
            this.server.setHostname(bindIp);
        }
        this.server.setPort(url.getParameter("bind.port", url.getPort()));
        HashMap<ChannelOption, Boolean> channelOption = new HashMap<ChannelOption, Boolean>();
        channelOption.put(ChannelOption.SO_KEEPALIVE, url.getParameter("keepalive", true));
        this.server.setChildChannelOptions(channelOption);
        this.server.setExecutorThreadCount(url.getParameter("threads", 200));
        this.server.setIoWorkerCount(url.getParameter("iothreads", Constants.DEFAULT_IO_THREADS));
        this.server.setMaxRequestSize(url.getParameter("payload", 0x800000));
        this.server.start();
    }

    @Override
    public void stop() {
        this.server.stop();
    }

    @Override
    protected ResteasyDeployment getDeployment() {
        return this.server.getDeployment();
    }
}

