/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.servlet.BootstrapListener;
import org.apache.dubbo.remoting.http.servlet.ServletManager;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.rest.ReferenceCountedClient;
import org.apache.dubbo.rpc.protocol.rest.RestProtocolServer;
import org.apache.dubbo.rpc.protocol.rest.RestServerFactory;
import org.apache.dubbo.rpc.protocol.rest.RpcContextFilter;
import org.apache.http.HeaderElement;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.util.GetRestful;

public class RestProtocol
extends AbstractProxyProtocol {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_SERVER = "jetty";
    private static final int HTTPCLIENTCONNECTIONMANAGER_MAXPERROUTE = 20;
    private static final int HTTPCLIENTCONNECTIONMANAGER_MAXTOTAL = 20;
    private static final int HTTPCLIENT_KEEPALIVEDURATION = 30000;
    private static final int HTTPCLIENTCONNECTIONMANAGER_CLOSEWAITTIME_MS = 1000;
    private static final int HTTPCLIENTCONNECTIONMANAGER_CLOSEIDLETIME_S = 30;
    private final RestServerFactory serverFactory = new RestServerFactory();
    private final Map<String, ReferenceCountedClient> clients = new ConcurrentHashMap<String, ReferenceCountedClient>();
    private volatile ConnectionMonitor connectionMonitor;

    public RestProtocol() {
        super(new Class[]{WebApplicationException.class, ProcessingException.class});
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.serverFactory.setHttpBinder(httpBinder);
    }

    public int getDefaultPort() {
        return 80;
    }

    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        String addr = this.getAddr(url);
        Class<?> implClass = url.getServiceModel().getProxyObject().getClass();
        RestProtocolServer server = (RestProtocolServer)this.serverMap.computeIfAbsent(addr, restServer -> {
            RestProtocolServer s = this.serverFactory.createServer(url.getParameter("server", DEFAULT_SERVER));
            s.setAddress(url.getAddress());
            s.start(url);
            return s;
        });
        String contextPath = this.getContextPath(url);
        if ("servlet".equalsIgnoreCase(url.getParameter("server", DEFAULT_SERVER))) {
            ServletContext servletContext = ServletManager.getInstance().getServletContext(-1234);
            if (servletContext == null) {
                throw new RpcException("No servlet context found. Since you are using server='servlet', make sure that you've configured " + BootstrapListener.class.getName() + " in web.xml");
            }
            String webappPath = servletContext.getContextPath();
            if (StringUtils.isNotEmpty((String)webappPath)) {
                if (!contextPath.startsWith(webappPath = webappPath.substring(1))) {
                    throw new RpcException("Since you are using server='servlet', make sure that the 'contextpath' property starts with the path of external webapp");
                }
                if ((contextPath = contextPath.substring(webappPath.length())).startsWith("/")) {
                    contextPath = contextPath.substring(1);
                }
            }
        }
        Class<Object> resourceDef = GetRestful.getRootResourceClass(implClass) != null ? implClass : type;
        server.deploy(resourceDef, impl, contextPath);
        RestProtocolServer s = server;
        return () -> s.undeploy(resourceDef);
    }

    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        ReferenceCountedClient referenceCountedClient = this.clients.computeIfAbsent(url.getAddress(), _key -> this.createReferenceCountedClient(url));
        if (referenceCountedClient.isDestroyed()) {
            referenceCountedClient = this.createReferenceCountedClient(url);
            this.clients.put(url.getAddress(), referenceCountedClient);
        }
        referenceCountedClient.retain();
        ResteasyClient resteasyClient = referenceCountedClient.getClient();
        for (String clazz : CommonConstants.COMMA_SPLIT_PATTERN.split(url.getParameter("extension", ""))) {
            if (StringUtils.isEmpty((String)clazz)) continue;
            try {
                resteasyClient.register(Thread.currentThread().getContextClassLoader().loadClass(clazz.trim()));
            }
            catch (ClassNotFoundException e) {
                throw new RpcException("Error loading JAX-RS extension class: " + clazz.trim(), (Throwable)e);
            }
        }
        ResteasyWebTarget target = resteasyClient.target("http://" + url.getAddress() + "/" + this.getContextPath(url));
        return (T)target.proxy(serviceType);
    }

    private ReferenceCountedClient createReferenceCountedClient(URL url) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(url.getParameter("connections", 20));
        connectionManager.setDefaultMaxPerRoute(url.getParameter("connections", 20));
        if (this.connectionMonitor == null) {
            this.connectionMonitor = new ConnectionMonitor();
            this.connectionMonitor.start();
        }
        this.connectionMonitor.addConnectionManager(url.getAddress(), connectionManager);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(url.getParameter("connect.timeout", 3000)).setSocketTimeout(url.getParameter("timeout", 1000)).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setTcpNoDelay(true).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy((response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return 30000L;
        }).setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).build();
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        ResteasyClient resteasyClient = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        resteasyClient.register(RpcContextFilter.class);
        return new ReferenceCountedClient(resteasyClient);
    }

    protected int getErrorCode(Throwable e) {
        return super.getErrorCode(e);
    }

    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying protocol [" + ((Object)((Object)this)).getClass().getSimpleName() + "] ...");
        }
        super.destroy();
        if (this.connectionMonitor != null) {
            this.connectionMonitor.shutdown();
        }
        for (Map.Entry entry : this.serverMap.entrySet()) {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Closing the rest server at " + (String)entry.getKey());
                }
                ((ProtocolServer)entry.getValue()).close();
            }
            catch (Throwable t) {
                this.logger.warn("Error closing rest server", t);
            }
        }
        this.serverMap.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closing rest clients");
        }
        for (ReferenceCountedClient client : this.clients.values()) {
            try {
                client.destroy();
            }
            catch (Throwable t) {
                this.logger.warn("Error closing rest client", t);
            }
        }
        this.clients.clear();
    }

    protected String getContextPath(URL url) {
        String contextPath = url.getPath();
        if (contextPath != null) {
            if (contextPath.equalsIgnoreCase(url.getParameter("interface"))) {
                return "";
            }
            if (contextPath.endsWith(url.getParameter("interface"))) {
                contextPath = contextPath.substring(0, contextPath.lastIndexOf(url.getParameter("interface")));
            }
            return contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath;
        }
        return "";
    }

    protected void destroyInternal(URL url) {
        try {
            ReferenceCountedClient referenceCountedClient = this.clients.get(url.getAddress());
            if (referenceCountedClient != null && referenceCountedClient.release()) {
                this.clients.remove(url.getAddress());
                this.connectionMonitor.destroyManager(url);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to close unused resources in rest protocol. interfaceName [" + url.getServiceInterface() + "]", (Throwable)e);
        }
    }

    protected class ConnectionMonitor
    extends Thread {
        private volatile boolean shutdown;
        private final Map<String, PoolingHttpClientConnectionManager> connectionManagers = new ConcurrentHashMap<String, PoolingHttpClientConnectionManager>();

        protected ConnectionMonitor() {
        }

        public void addConnectionManager(String address, PoolingHttpClientConnectionManager connectionManager) {
            this.connectionManagers.putIfAbsent(address, connectionManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    ConnectionMonitor connectionMonitor = this;
                    synchronized (connectionMonitor) {
                        this.wait(1000L);
                        for (PoolingHttpClientConnectionManager connectionManager : this.connectionManagers.values()) {
                            connectionManager.closeExpiredConnections();
                            connectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                        }
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            this.connectionManagers.clear();
            ConnectionMonitor connectionMonitor = this;
            synchronized (connectionMonitor) {
                this.notifyAll();
            }
        }

        private void destroyManager(URL url) {
            PoolingHttpClientConnectionManager connectionManager = this.connectionManagers.remove(url.getAddress());
            if (connectionManager != null) {
                connectionManager.close();
            }
        }
    }
}

