/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.rest.DubboHttpProtocolServer;
import org.apache.dubbo.rpc.protocol.rest.NettyRestProtocolServer;
import org.apache.dubbo.rpc.protocol.rest.RestProtocolServer;

public class RestServerFactory {
    private static final HttpBinder httpBinder = (HttpBinder)FrameworkModel.defaultModel().getAdaptiveExtension(HttpBinder.class);

    public RestProtocolServer createServer(String name) {
        if ("servlet".equalsIgnoreCase(name) || "jetty".equalsIgnoreCase(name) || "tomcat".equalsIgnoreCase(name)) {
            return new DubboHttpProtocolServer(httpBinder);
        }
        if ("netty".equalsIgnoreCase(name)) {
            return new NettyRestProtocolServer();
        }
        throw new IllegalArgumentException("Unrecognized server name: " + name);
    }
}

