/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Priority(value=-2147483647)
public class RpcContextFilter
implements ContainerRequestFilter,
ClientRequestFilter {
    private static final String DUBBO_ATTACHMENT_HEADER = "Dubbo-Attachments";
    private static final int MAX_HEADER_SIZE = 8192;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        RpcContext.getServiceContext().setRequest((Object)request);
        if (request != null && RpcContext.getServiceContext().getRemoteAddress() == null) {
            RpcContext.getServiceContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
        }
        RpcContext.getServiceContext().setResponse(ResteasyProviderFactory.getContextData(HttpServletResponse.class));
        String headers = requestContext.getHeaderString(DUBBO_ATTACHMENT_HEADER);
        if (headers != null) {
            for (String header : headers.split(",")) {
                int index = header.indexOf("=");
                if (index <= 0) continue;
                String key = header.substring(0, index);
                String value = header.substring(index + 1);
                if (StringUtils.isEmpty((String)key)) continue;
                RpcContext.getServerAttachment().setAttachment(key.trim(), value.trim());
            }
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        int size = 0;
        HashMap objectAttachments = new HashMap(RpcContext.getClientAttachment().getObjectAttachments());
        Invocation invocation = RpcContext.getServiceContext().getInvocation();
        if (invocation != null && CollectionUtils.isNotEmptyMap((Map)invocation.getObjectAttachments())) {
            objectAttachments.putAll(invocation.getObjectAttachments());
        }
        for (Map.Entry entry : objectAttachments.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.illegalHttpHeaderKey(key) || this.illegalHttpHeaderValue(value)) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " must not contain ',' or '=' when using rest protocol");
            }
            if (value != null) {
                size += value.getBytes(StandardCharsets.UTF_8).length;
            }
            if (size > 8192) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " is too big");
            }
            String attachments = key + "=" + value;
            requestContext.getHeaders().add((Object)DUBBO_ATTACHMENT_HEADER, (Object)attachments);
        }
    }

    private boolean illegalHttpHeaderKey(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            return key.contains(",") || key.contains("=");
        }
        return false;
    }

    private boolean illegalHttpHeaderValue(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            return value.contains(",");
        }
        return false;
    }
}

