/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.consumer.inercept;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionCreateContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;

@Activate(value={"rpc-context"}, order=3)
public class AttachmentIntercept
implements HttpConnectionPreBuildIntercept {
    @Override
    public void intercept(HttpConnectionCreateContext connectionCreateContext) {
        RequestTemplate requestTemplate = connectionCreateContext.getRequestTemplate();
        int size = 0;
        for (Map.Entry entry : connectionCreateContext.getInvocation().getObjectAttachments().entrySet()) {
            String key = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            if (this.illegalHttpHeaderKey(key) || this.illegalHttpHeaderValue(value)) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " must not contain ',' or '=' when using rest protocol");
            }
            if (value != null) {
                size += value.getBytes(StandardCharsets.UTF_8).length;
            }
            if (size > 8192) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " is too big");
            }
            String attachments = key + "=" + value;
            requestTemplate.addHeader("Dubbo-Attachments", attachments);
        }
    }

    private boolean illegalHttpHeaderKey(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            return key.contains(",") || key.contains("=");
        }
        return false;
    }

    private boolean illegalHttpHeaderValue(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            return value.contains(",");
        }
        return false;
    }
}

