/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.consumer.inercept;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionCreateContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;

@Activate(value={"serialize"}, order=0x7FFFFFFF)
public class SerializeBodyIntercept
implements HttpConnectionPreBuildIntercept {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SerializeBodyIntercept.class);

    @Override
    public void intercept(HttpConnectionCreateContext connectionCreateContext) {
        RequestTemplate requestTemplate = connectionCreateContext.getRequestTemplate();
        if (requestTemplate.isBodyEmpty()) {
            return;
        }
        try {
            Object unSerializedBody = requestTemplate.getUnSerializedBody();
            URL url = connectionCreateContext.getUrl();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Collection headers = requestTemplate.getHeaders("Content-Type");
            MediaType mediaType = MediaTypeUtil.convertMediaType(headers.toArray(new String[0]));
            HttpMessageCodecManager.httpMessageEncode(outputStream, unSerializedBody, url, mediaType);
            requestTemplate.serializeBody(outputStream.toByteArray());
        }
        catch (Exception e) {
            logger.error("4-6", "", "", "Rest SerializeBodyIntercept serialize error: {}", (Throwable)e);
        }
    }
}

