/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message;

import java.io.OutputStream;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.rest.exception.UnSupportContentTypeException;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;

public class HttpMessageCodecManager {
    private static final Set<HttpMessageCodec> httpMessageCodecs = FrameworkModel.defaultModel().getExtensionLoader(HttpMessageCodec.class).getSupportedExtensionInstances();

    public static Object httpMessageDecode(byte[] body, Class type, MediaType mediaType) throws Exception {
        for (HttpMessageCodec httpMessageCodec : httpMessageCodecs) {
            if (!httpMessageCodec.contentTypeSupport(mediaType, type)) continue;
            return httpMessageCodec.decode(body, type);
        }
        throw new UnSupportContentTypeException("UnSupport content-type :" + mediaType.value);
    }

    public static void httpMessageEncode(OutputStream outputStream, Object unSerializedBody, URL url, MediaType mediaType) throws Exception {
        for (HttpMessageCodec httpMessageCodec : httpMessageCodecs) {
            if (!httpMessageCodec.contentTypeSupport(mediaType, unSerializedBody.getClass())) continue;
            httpMessageCodec.encode(outputStream, unSerializedBody, url);
            return;
        }
        throw new UnSupportContentTypeException("UnSupport content-type :" + mediaType.value);
    }
}

