/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metadata.rest.media.MediaType;

public enum MediaTypeMatcher {
    MULTI_VALUE(MediaTypeMatcher.createMediaList(MediaType.APPLICATION_FORM_URLENCODED_VALUE)),
    APPLICATION_JSON(MediaTypeMatcher.createMediaList(MediaType.APPLICATION_JSON_VALUE)),
    TEXT_PLAIN(MediaTypeMatcher.createMediaList(MediaType.TEXT_PLAIN, MediaType.OCTET_STREAM)),
    TEXT_XML(MediaTypeMatcher.createMediaList(MediaType.TEXT_XML));

    private List<MediaType> mediaTypes;

    private MediaTypeMatcher(List<MediaType> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    private static List<MediaType> createMediaList(MediaType ... mediaTypes) {
        List<MediaType> mediaTypeList = MediaTypeMatcher.getDefaultList();
        for (MediaType mediaType : mediaTypes) {
            mediaTypeList.add(mediaType);
        }
        return mediaTypeList;
    }

    private static List<MediaType> getDefaultList() {
        ArrayList<MediaType> defaultList = new ArrayList<MediaType>();
        defaultList.add(MediaType.ALL_VALUE);
        return defaultList;
    }

    public boolean mediaSupport(MediaType mediaType) {
        return this.mediaTypes.contains(mediaType);
    }
}

