/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectUtils {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static Field getField(Class clazz, String field) throws IllegalAccessException {
        Field[] fields;
        for (Field field1 : fields = clazz.getDeclaredFields()) {
            if (!field1.getName().equals(field)) continue;
            return ReflectUtils.setModifiersUnFinal(field1);
        }
        for (Field field1 : fields = clazz.getFields()) {
            if (!field1.getName().equals(field)) continue;
            return ReflectUtils.setModifiersUnFinal(field1);
        }
        return null;
    }

    public static Method getMethod(Class clazz, String method, Class[] paramTypes) throws NoSuchMethodException {
        Method declaredMethod = clazz.getDeclaredMethod(method, paramTypes);
        declaredMethod.setAccessible(true);
        return declaredMethod;
    }

    private static Field setModifiersUnFinal(Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return field;
    }

    public static Class findClass(String name) throws ClassNotFoundException {
        return ReflectUtils.findClass(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Class findClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass(name);
    }

    public static Class findClassAndTryCatch(String name, ClassLoader classLoader) {
        try {
            return ReflectUtils.findClass(name, classLoader);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Class findClass(String ... name) throws ClassNotFoundException {
        return ReflectUtils.findClass(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Class findClass(ClassLoader classLoader, String ... name) throws ClassNotFoundException {
        String[] names;
        for (String s : names = name) {
            Class tmp = ReflectUtils.findClassAndTryCatch(s, classLoader);
            if (tmp == null) continue;
            return tmp;
        }
        throw new ClassNotFoundException();
    }

    public static Class findClassTryException(ClassLoader classLoader, String ... name) {
        try {
            return ReflectUtils.findClass(classLoader, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class findClassTryException(String ... name) {
        return ReflectUtils.findClassTryException(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Object getArrayElement(Object obj, int index) {
        return Array.get(obj, index);
    }

    public static List<Object> getArrayElements(Object obj) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int length = Array.getLength(obj);
        if (length == 0) {
            return objects;
        }
        for (int i = 0; i < length; ++i) {
            objects.add(Array.get(obj, i));
        }
        return objects;
    }

    public static Field getFieldAndTryCatch(Class clazz, String field) {
        try {
            return ReflectUtils.getField(clazz, field);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getMethod(Class clazz, String method) throws NoSuchMethodException {
        Method declaredMethod = clazz.getDeclaredMethod(method, new Class[0]);
        declaredMethod.setAccessible(true);
        return declaredMethod;
    }

    public static Method getMethodAndTry(Class clazz, String method) {
        Method declaredMethod = null;
        try {
            declaredMethod = clazz.getDeclaredMethod(method, EMPTY_CLASS_ARRAY);
            declaredMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (declaredMethod == null) {
            try {
                declaredMethod = ReflectUtils.getMethodByName(clazz, method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return declaredMethod;
    }

    public static Object invoke(Object object, Method method) {
        try {
            return method.invoke(object, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invoke(Object object, Method method, Object[] params) throws InvocationTargetException, IllegalAccessException {
        return method.invoke(object, params);
    }

    public static Object invokeAndTryCatch(Object object, Method method, Object[] params) {
        try {
            return ReflectUtils.invoke(object, method, params);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class findClassAndTry(String name) {
        try {
            return ReflectUtils.findClass(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getMethodByName(Class clazz, String name) {
        Method[] declaredMethods;
        for (Method declaredMethod : declaredMethods = clazz.getMethods()) {
            if (!name.equals(declaredMethod.getName())) continue;
            return declaredMethod;
        }
        return null;
    }

    public static Object getValueByFields(Object obj, Field ... fields) {
        for (Field field : fields) {
            try {
                Object o = field.get(obj);
                if (o == null) continue;
                return o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getMethodAndTryCatch(Class clazz, String method, Class[] paramTypes) {
        try {
            return ReflectUtils.getMethod(clazz, method, paramTypes);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object getFieldValueAndTryCatch(Object obj, String field) {
        try {
            return ReflectUtils.getValueByFields(obj, ReflectUtils.getFieldAndTryCatch(obj.getClass(), field));
        }
        catch (Exception e) {
            return null;
        }
    }
}

