/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.rest.exception.DoublePathCheckException;
import org.apache.dubbo.rpc.protocol.rest.exception.PathNoFoundException;
import org.apache.dubbo.rpc.protocol.rest.pair.InvokerAndRestMethodMetadataPair;

public class PathAndInvokerMapper {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(PathAndInvokerMapper.class);
    private final Map<PathMatcher, InvokerAndRestMethodMetadataPair> pathToServiceMapContainPathVariable = new ConcurrentHashMap<PathMatcher, InvokerAndRestMethodMetadataPair>();
    private final Map<PathMatcher, InvokerAndRestMethodMetadataPair> pathToServiceMapNoPathVariable = new ConcurrentHashMap<PathMatcher, InvokerAndRestMethodMetadataPair>();

    public void addPathAndInvoker(Map<PathMatcher, RestMethodMetadata> metadataMap, Invoker invoker) {
        metadataMap.entrySet().stream().forEach(entry -> {
            PathMatcher pathMatcher = (PathMatcher)entry.getKey();
            if (pathMatcher.hasPathVariable()) {
                this.addPathMatcherToPathMap(pathMatcher, this.pathToServiceMapContainPathVariable, InvokerAndRestMethodMetadataPair.pair(invoker, (RestMethodMetadata)entry.getValue()));
            } else {
                this.addPathMatcherToPathMap(pathMatcher, this.pathToServiceMapNoPathVariable, InvokerAndRestMethodMetadataPair.pair(invoker, (RestMethodMetadata)entry.getValue()));
            }
        });
    }

    public InvokerAndRestMethodMetadataPair getRestMethodMetadata(String path, String version, String group, Integer port) {
        PathMatcher pathMather = PathMatcher.getInvokeCreatePathMatcher((String)path, (String)version, (String)group, (Integer)port);
        if (this.pathToServiceMapNoPathVariable.containsKey(pathMather)) {
            return this.pathToServiceMapNoPathVariable.get(pathMather);
        }
        if (this.pathToServiceMapContainPathVariable.containsKey(pathMather)) {
            return this.pathToServiceMapContainPathVariable.get(pathMather);
        }
        throw new PathNoFoundException("rest service Path no found, current path info:" + pathMather);
    }

    public void removePath(PathMatcher pathMatcher) {
        InvokerAndRestMethodMetadataPair containPathVariablePair = this.pathToServiceMapContainPathVariable.remove(pathMatcher);
        InvokerAndRestMethodMetadataPair unContainPathVariablePair = this.pathToServiceMapNoPathVariable.remove(pathMatcher);
        logger.info("dubbo rest undeploy pathMatcher:" + pathMatcher + ", and path variable method is :" + (containPathVariablePair == null ? null : containPathVariablePair.getRestMethodMetadata().getReflectMethod()) + ", and no path variable  method is :" + (unContainPathVariablePair == null ? null : unContainPathVariablePair.getRestMethodMetadata().getReflectMethod()));
    }

    public void addPathMatcherToPathMap(PathMatcher pathMatcher, Map<PathMatcher, InvokerAndRestMethodMetadataPair> pathMatcherPairMap, InvokerAndRestMethodMetadataPair invokerRestMethodMetadataPair) {
        if (pathMatcherPairMap.containsKey(pathMatcher)) {
            InvokerAndRestMethodMetadataPair beforeMetadata = pathMatcherPairMap.get(pathMatcher);
            throw new DoublePathCheckException("dubbo rest double path check error, current path is: " + pathMatcher + " ,and service method is: " + invokerRestMethodMetadataPair.getRestMethodMetadata().getReflectMethod() + "before service  method is: " + beforeMetadata.getRestMethodMetadata().getReflectMethod());
        }
        pathMatcherPairMap.put(pathMatcher, invokerRestMethodMetadataPair);
        logger.info("dubbo rest deploy pathMatcher:" + pathMatcher + ", and service method is :" + invokerRestMethodMetadataPair.getRestMethodMetadata().getReflectMethod());
    }
}

