/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;
import org.apache.dubbo.rpc.protocol.rest.message.MediaTypeMatcher;
import org.apache.dubbo.rpc.protocol.rest.util.DataParseUtils;

@Activate(value={"json"})
public class JsonCodec
implements HttpMessageCodec<byte[], OutputStream> {
    private static final Set<Class> unSupportClasses = new HashSet<Class>();

    @Override
    public Object decode(byte[] body, Class<?> targetType) throws Exception {
        return DataParseUtils.jsonConvert(targetType, body);
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class<?> targetType) {
        return MediaTypeMatcher.APPLICATION_JSON.mediaSupport(mediaType) && !unSupportClasses.contains(targetType);
    }

    @Override
    public boolean typeSupport(Class<?> targetType) {
        return !unSupportClasses.contains(targetType) && !DataParseUtils.isTextType(targetType);
    }

    @Override
    public MediaType contentType() {
        return MediaType.APPLICATION_JSON_VALUE;
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody, URL url) throws Exception {
        outputStream.write(JsonUtils.toJson((Object)unSerializedBody).getBytes(StandardCharsets.UTF_8));
    }

    static {
        unSupportClasses.add(byte[].class);
        unSupportClasses.add(String.class);
    }
}

