/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.handler.NettyHttpHandler;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.NettyRequestFacade;

public class RestHttpRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());
    private final Executor executor;
    private final ServiceDeployer serviceDeployer;
    private final URL url;
    private final NettyHttpHandler nettyHttpHandler;

    public RestHttpRequestDecoder(URL url, ServiceDeployer serviceDeployer) {
        this.url = url;
        this.serviceDeployer = serviceDeployer;
        this.executor = ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).createExecutorIfAbsent(ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler"));
        this.nettyHttpHandler = new NettyHttpHandler(serviceDeployer, url);
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest request, List<Object> out) throws Exception {
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        NettyHttpResponse nettyHttpResponse = new NettyHttpResponse(ctx, keepAlive, this.url);
        NettyRequestFacade requestFacade = new NettyRequestFacade(request, ctx, this.serviceDeployer);
        this.executor.execute(() -> {
            try {
                this.nettyHttpHandler.handle(requestFacade, nettyHttpResponse);
            }
            catch (IOException e) {
                this.logger.error("", e.getCause().getMessage(), "dubbo rest rest http request handler error", e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    nettyHttpResponse.addOutputHeaders(RestHeaderEnum.CONNECTION.getHeader(), "close");
                    nettyHttpResponse.finish();
                }
                catch (IOException e) {
                    this.logger.error("", e.getCause().getMessage(), "dubbo rest rest http response flush error", e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

