/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.rest.RestConstraintViolation;
import org.apache.dubbo.rpc.protocol.rest.ViolationReport;

public class ConstraintViolationExceptionConvert {
    public static Object handleConstraintViolationException(RpcException rpcException) {
        ConstraintViolationException cve = (ConstraintViolationException)rpcException.getCause();
        ViolationReport report = new ViolationReport();
        for (ConstraintViolation cv : cve.getConstraintViolations()) {
            report.addConstraintViolation(new RestConstraintViolation(cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
        }
        return report;
    }

    public static boolean needConvert(RpcException e) {
        return ConstraintViolationExceptionConvert.isConstraintViolationException(e);
    }

    private static boolean isConstraintViolationException(RpcException e) {
        try {
            return e.getCause() instanceof ConstraintViolationException;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

