/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;

@Activate(onClass={"javax.ws.rs.core.Response"})
public class ResteasyResponseCodec
implements HttpMessageCodec<byte[], OutputStream> {
    private Class<?> responseClass;

    public ResteasyResponseCodec() {
        try {
            this.responseClass = ClassUtils.forName((String)"javax.ws.rs.core.Response");
        }
        catch (Exception exception) {
            this.responseClass = null;
        }
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class<?> targetType) {
        return this.isMatch(targetType);
    }

    @Override
    public boolean typeSupport(Class<?> targetType) {
        return this.isMatch(targetType);
    }

    @Override
    public MediaType contentType() {
        return MediaType.APPLICATION_JSON_VALUE;
    }

    @Override
    public Object decode(byte[] body, Class<?> targetType) throws Exception {
        if (null == body || body.length == 0) {
            return null;
        }
        Class builtResponse = ClassUtils.forName((String)"org.jboss.resteasy.specimpl.BuiltResponse");
        Object o = builtResponse.newInstance();
        Method method = builtResponse.getMethod("setEntity", Object.class);
        method.invoke(o, new String(body, StandardCharsets.UTF_8));
        return o;
    }

    @Override
    public void encode(OutputStream os, Object target, URL url) throws Exception {
        if (target != null) {
            Method method = target.getClass().getMethod("getEntity", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke(target, new Object[0]);
            os.write(JsonUtils.toJson((Object)result).getBytes(StandardCharsets.UTF_8));
        }
    }

    private boolean isMatch(Class<?> targetType) {
        return this.responseClass != null && null != targetType && this.responseClass.isAssignableFrom(targetType);
    }
}

